import re

def split_cmd_statements(cmd):
    cmd = re.sub(r'\\\s*\n', '', cmd)
    cmd = re.sub(r'\n', ' ', cmd)
    statements = re.split(r'\s*&&\s*', cmd)
    
    return [statement.strip() for statement in statements]

if __name__ == "__main__":
    # cmd = "echo Hello World\\\necho This is\\ a test && echo Another command"
    cmd = '''waitinglist add -p crawlerdetect -v "~0.1.7" -t pip && \
waitinglist add -p fastapi -v "~0.110" -t pip && \
waitinglist add -p fuzzywuzzy -v "~0.18" -t pip && \
waitinglist add -p gitignore-parser -v "==0.1.11" -t pip && \
waitinglist add -p imy[docstrings] -v ">=0.4.0" -t pip && \
waitinglist add -p introspection -v "~1.9.2" -t pip && \
waitinglist add -p isort -v "~5.13" -t pip && \
waitinglist add -p keyring -v "~24.3" -t pip && \
waitinglist add -p langcodes -v ">=3.4.0" -t pip && \
waitinglist add -p narwhals -v ">=1.12.1" -t pip && \
waitinglist add -p ordered-set -v ">=4.1.0" -t pip && \
waitinglist add -p path-imports -v ">=1.1.2" -t pip && \
waitinglist add -p pillow -v "~10.2" -t pip && \
waitinglist add -p python-levenshtein -v "~0.23" -t pip && \
waitinglist add -p python-multipart -v "~0.0.6" -t pip && \
waitinglist add -p pytz -v "~2024.1" -t pip && \
waitinglist add -p revel -v "~0.9.1" -t pip && \
waitinglist add -p timer-dict -v "~1.0" -t pip && \
waitinglist add -p tomlkit -v "~0.12" -t pip && \
waitinglist add -p typing-extensions -v ">=4.5" -t pip && \
waitinglist add -p unicall -v "~0.1.5" -t pip && \
waitinglist add -p uniserde -v "~0.3.14" -t pip && \
waitinglist add -p uvicorn[standard] -v "~0.29.0" -t pip && \
waitinglist add -p watchfiles -v "~0.21" -t pip && \
waitinglist add -p yarl -v ">=1.9" -t pip
'''
    result = split_cmd_statements(cmd)
    print(result)

    for i, statement in enumerate(result, 1):
        print(f"Statement {i}: {statement}")