import multiprocessing
import subprocess
import os
import sys
import random
import time


def run_command(command):
    # os.system('docker images --filter "dangling=true" --format "{{.ID}}" | xargs -r docker rmi')
    current_time = time.time()
    local_time = time.localtime(current_time)

    formatted_time = time.strftime("%Y-%m-%d %H:%M:%S", local_time)
    print(f'Start time: {formatted_time}')
    full_name = command.split('python -u main.py "')[1].split('"')[0]

    vdb = subprocess.run("df -h | grep '/dev/vdb' | awk '{print $5}'", shell=True, capture_output=True, text=True)
    if float(vdb.stdout.strip().split('%')[0]) > 90:
        print('Warning! The disk /dev/vdb has occupied over 90% memories!')
        sys.exit(1)
    try:
        print(f'Begin: {command}')
        subprocess.run(command, shell=True)
        print(f'Finish: {command}')
        finish_command.append(command.split('python main.py "')[1].split('"')[0].lower().replace('/', '_').replace('-', '_'))
        for fc in finish_command:
            try:
                rm_cmd = f'docker ps -a --filter ancestor={fc}:tmp -q | xargs -r docker rm'
                subprocess.run(rm_cmd, shell=True, capture_output=True, text=True)
            except:
                pass
    except Exception as e:
        print(f"Error: {command}, {e}")

if __name__ == '__main__':
    os.system('docker rm -f $(docker ps -aq)')

    if len(sys.argv) != 2:
        print('Usage: python multi_main.py <script_path>')
        sys.exit(1)
    script_path = sys.argv[1]


    try:
        with open(script_path, 'r') as r1:
            commands = r1.readlines()
    except:
        print(f'Error: {script_path}')
        sys.exit(1)

    finish_command = list()
    random.shuffle(commands)

    with multiprocessing.Pool(processes=3) as pool:
        pool.map(run_command, commands)