#!/usr/bin/env python3
import subprocess
import argparse
import warnings
import sys
warnings.simplefilter('ignore', FutureWarning)

def update_apt(sudo=False):
    try:
        update_command = f'{"sudo " if sudo else ""}apt-get update'
        result = subprocess.run(update_command, shell=True, check=True, text=True, capture_output=True)
        print("Apt-get Update Ouput:\n", result.stdout)
        if result.stderr:
            print("Apt-get Update Warnings:\n", result.stderr)
        return True, result
    except subprocess.CalledProcessError as e:
        print("An error occurred while 'apt-get update':", e.stderr)
        print(e.stdout)
        print("Please try again!")
        return False, e

def run_apt(package_name, version_constraints, sudo=False):
    success, result = update_apt(sudo)
    if not success:
        return False, result
    if not version_constraints or len(version_constraints.strip()) == 0:
        full_name = package_name
    else:
        full_name = package_name + version_constraints
    apt_command = f'{"sudo " if sudo else ""}apt-get install -y ' + full_name
    print(f"Extract command `{apt_command}`, about to execute...")
    try:
        result = subprocess.run(apt_command, shell=True, check=True, text=True, capture_output=True)
        print("Apt-get Output:\n", result.stdout)
        if result.stderr:
            print("Apt-get Warnings:\n", result.stderr)
        return True, result
    except subprocess.CalledProcessError as e:
        print("An error occurred while running 'apt-get install':", e.stderr)
        print(e.stdout)
        return False, e

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Install a package with apt-get.')
    parser.add_argument('-p', '--package_name', required=True, type=str, help='The name of the package to install.')
    parser.add_argument('-v', '--version_constraints', type=str, default='', nargs='?', help='The version constraints of the package.')

    args = parser.parse_args()
    success, res = run_apt(args.package_name, args.version_constraints)
    if not success:
        sys.exit(1)
    else:
        sys.exit(0)