import subprocess
import re
def collect_test_cases(file_content):
    lines = file_content.strip().split('\n')
    lines = lines[:-2]
    test_cases = []
    
    pattern = re.compile(r'^[^\[]+')

    for line in lines:
        match = pattern.match(line)
        if match:
            test_case = match.group()
            if test_case not in test_cases:
                test_cases.append(test_case)
    
    return test_cases

subprocess.run('pytest --collect-only -q > tests.txt', shell=True)
with open('tests.txt', 'r') as r1:
    file_content = r1.read()
test_cases = collect_test_cases(file_content)
for test_case in test_cases:
    print(test_case)
