import openai

def get_llm_response(model: str, messages, temperature = 0.0, n = 1, max_tokens = 1024):
    max_retry = 5
    count = 0
    while count < max_retry:
        try:
            response = openai.ChatCompletion.create(
                model=model,
                messages=messages,
                temperature=temperature,
                n=n,
                max_tokens=max_tokens
            )
            return response.choices[0].message.content, response.usage
        except Exception as e:
            print(f"Error: {e}")
            count += 1
            time.sleep(3)
    return None, None