import io
import sys
from contextlib import redirect_stdout

class OutputCollector:
    def __init__(self):
        self.output = io.StringIO()

    def __enter__(self):
        self.old_stdout = sys.stdout
        sys.stdout = self.output
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        sys.stdout = self.old_stdout
        
    def get_output(self):
        return self.output.getvalue()
        