import re

BASH_FENCE = ['```bash', '```']

def extract_dialogue(text):
    pattern = re.compile(
        r"\s*###\s*Thought\s*:\s*(.*?)\s*###\s*Action\s*:\s*(.*)", 
        re.IGNORECASE | re.DOTALL
    )
    match = pattern.match(text)
    
    if match:
        thought = match.group(1).strip()
        action = match.group(2).strip()
        return thought, action
    else:
        return None, None

def extract_dialogue_warnings(text):
    text = text.strip()
    thought, action = extract_dialogue(text)
    if not thought or not action:
        print(f'''All your answer must contain Thought and Action. Calling CLI tools Action using bash block like {BASH_FENCE[0]}  {BASH_FENCE[1]}. Please modify the format of your answer and resubmit it.
For example, below shows an answer with legal format:
### Thought: I need to read the README.md file.
### Action:
{BASH_FENCE[0]} 
cat README.md
{BASH_FENCE[1]}
''')
    return thought, action

if __name__ == '__main__':
    print(extract_dialogue_warnings('''
    ### Thught:
thought   1

### action:
Action!!!
    '''))