# Code for Improved motif-scaffolding with SE(3) flow matching

This folder contains inference and training code.
We do not include the training dataset since it is too large to compress.

## Installation

```bash
# Conda environment with dependencies.
conda env create -f fm.yml

# Activate environment
conda activate fm

# Manually need to install torch-scatter.
pip install torch-scatter -f https://data.pyg.org/whl/torch-2.0.0+cu117.html

# Install local package.
# Current directory should be flow-matching/
pip install -e .
```

## Training

Following our paper we train two versions of FrameFlow on the PDB dataset. The first command trains FrameFlow unconditionally and is used by FrameFlow-guidance

```bash
python -W ignore experiments/train_se3_flows.py -cn pdb_hallucination
```

The second command trains FrameFlow conditionally and is used by FrameFlow-amortization.

```bash
python -W ignore experiments/train_se3_flows.py -cn pdb_inpainting
```

## Inference

Model weights can be downloaded from the [anonymous dropbox link](https://www.dropbox.com/scl/fo/cjw6e0wqor6hdvzgy9jri/h?rlkey=km8wdjwd4376qiymnabgfhba3&dl=0)
We include the model weights for each model trained in our experiments.
Place the wieghts in the following folder.

* `weights/amortization_weights.ckpt` unconditional frameflow weights.
* `weights/guidance_weights.ckpt` conditional frameflow weights.

To run inference on unconditional backbone generation (hallucination):
```bash
python -W ignore experiments/inference_se3_flows.py -cn inference_unconditional
```

To run inference on motif-scaffolding with FrameFlow-amortization
```bash
python -W ignore experiments/inference_se3_flows.py -cn inference_scaffolding
```

To run inference on motif-scaffolding with FrameFlow-guidance
```bash
python -W ignore experiments/inference_se3_flows.py -cn inference_scaffolding_guidance
```
