# for use inside a docker container (or enroot image) based on the docker image "pytorch/pytorch" which is based on Ubuntu

# Example setup with enroot (needs to be installed on the host system - please check the appendix first, if you have not)

# Last tested on: 2021-10-04

# $ enroot import -o pytorch.sqsh docker://pytorch/pytorch:1.8.1-cuda11.1-cudnn8-runtime
# $ enroot create pytorch.sqsh
# $ enroot start --root --rw -m ".":"/workspace" -- pytorch ./install.sh
# afterwards either use the container directly or
# exit the container, and repack the modified image:
# $ enroot export --output boolnet.sqsh pytorch
# $ enroot remove pytorch && rm pytorch.sqsh
# $ enroot create boolnet.sqsh
# then you can enter the src directory and re-run the training command (e.g. with 4 GPU):
# $ cd BaseNet_k_1/src
# $ enroot start --rw -m "/path/to/imagenet/data":"/mnt/imagenet" -m ".":"/workspace" -m "${HOME}/.cache:${HOME}/.cache" -e NUM_GPU=4 -e PYTHONPATH=/workspace -e PYTHONUNBUFFERED=x -- boolnet ./run.sh

# Installing essentials
apt-get update
apt-get -y install \
    build-essential \
    git \
    python-dev \
    python-setuptools \
    python-pip \
    python-smbus \
    libglib2.0-0 \
    libgl1-mesa-glx \
    vim

# Installing apex
git clone https://github.com/NVIDIA/apex && cd apex && python3 setup.py install

# Installing NVIDIA DALI Library
pip install --extra-index-url https://developer.download.nvidia.com/compute/redist --upgrade nvidia-dali-cuda110

# Installing tensorboard X, torchtoolbox and pandas
pip install torchtoolbox tensorboardX pandas

# Installing torch, torchvision
pip install torch==1.8.1+cu111 torchvision==0.9.1+cu111 torchaudio==0.8.1 -f https://download.pytorch.org/whl/torch_stable.html
