# Multi-GPU Launch Helpers

`multi_gpu_launcher.py` automatically splits prompts across multiple GPUs, starting one `sample.sh` process per card:

```bash
python RUN/multi_gpu_launcher.py \
  --mode HiCache \
  --gpus 0,1 \
  --prompt-file prompt.txt \
  --base-output-dir results/hicache_multi \
  -- --limit 8 --hicache_scale 0.6
```

- `--gpus` specifies the GPU list to use (if not provided, tries to read `CUDA_VISIBLE_DEVICES` or `torch.cuda.device_count()`).
- Additional parameters after `--` are forwarded as-is to `sample.sh` (forbidden to repeat `--mode`, `--prompt_file`, `--output_dir`).
- Output directories automatically append `_<mode>_<timestamp>_gpuX` suffix to avoid overlap.
- By default, temporary prompt slices are deleted after completion. Add `--keep-temp` to retain them.
