# Environment Setup

This project targets Python 3.10 or newer. The recommended workflow is to create an isolated virtual environment and install the package in editable mode.

```bash
python3.10 -m venv .venv
source .venv/bin/activate
pip install --upgrade pip
pip install -e ".[all]"
```

## Optional: Pre-download Checkpoints

Use `download_flux.py` or `hf_download.py` to fetch the required Hugging Face snapshots into the local `models/` directory. Set `HF_TOKEN` if the repository requires authentication.

```bash
export HF_TOKEN=hf_xxx   # if needed
./download_flux.py --repo-id black-forest-labs/FLUX.1-dev
```

Downloaded assets live outside of version control by default (`models/` is kept empty apart from documentation). Feel free to adjust the destination paths with `--local-dir`.
