function DklUCB(Table,nbreak=0,gamma=0.95)
    # table contains a table of rewards for the K arms up to horizon T
    (K,T)=size(Table)
    episode=1
    ChangePoints = []
    if (nbreak>0)
       # optimized gamma as a function of the nb of breakpoints 
       gamma = 1- 0.25*sqrt(nbBreaks/T)
    end
    DiscNumber=zeros(Float32,K) # discounted number of selections 
    DiscSum=zeros(Float32,K) # discounted sum of rewards
    Time =0 # discounted total number of pulls 
    ChosenArms = zeros(Int,T)
    ReceivedRewards = zeros(T)
    for t in 1:T
       # compute KL-UCB indices 
       indices = ones(K)
       for i in 1:K
          if (DiscNumber[i]>0)
             indices[i]=klUp(DiscSum[i]/DiscNumber[i],log(Time)/DiscNumber[i])
          end
       end
       I = randmax(indices)
       # get the reward  
       rew = Table[I,t]
       ChosenArms[t]=I 
       ReceivedRewards[t]=rew
       # update everything
       DiscNumber = gamma*DiscNumber
       DiscNumber[I]+=1
       DiscSum = gamma*DiscSum
       DiscSum[I]+=rew
       Time = 1+gamma*Time
    end
    return ChosenArms,ReceivedRewards,episode,ChangePoints
 end