import numpy as np

def env_list(horizon, envId = 0, rand_instance = False):
    if rand_instance == False:
        ENVIRONMENTS = [ 
                # envId = 0
                {   # A simple piece-wise stationary problem
                    "env_type" : "Others",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.9, 0.5, 0.2],  # 0    to 399
                            [0.9, 0.2, 0.2],  # 400  to 799
                            [0.1, 0.2, 0.2],  # 800  to 1199
                            [0.1, 0.7, 0.2],  # 1200 to 1599
                            [0.1, 0.7, 0.5],  # 1600 to end
                        ],
                        "changePoints": [
                            int(0    * horizon / 5),
                            int(1    * horizon / 5),
                            int(2    * horizon / 5),
                            int(3    * horizon / 5),
                            int(4    * horizon / 5),
                        ],
                    }
                },
                # envId = 1
                {   # A simple piece-wise stationary problem
                    "env_type" : "Type-II",
                    "params": {
                        "listOfMeans": [
                            [0.5, 0.8],  # 0    to 399
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                        ],
                        "changePoints": [
                            int(0    * horizon / 5),
                            int(1    * horizon / 5),
                            int(2    * horizon / 5),
                            int(3    * horizon / 5),
                            int(4    * horizon / 5),
                        ],
                    }
                },
                # envId = 2
                {   # A simple piece-wise stationary problem
                    "env_type" : "Others",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.5, 0.2, 0.3],  # 0    to 399
                            [0.5, 0.6, 0.3],  # 400  to 799
                            [0.5, 0.6, 0.7],  # 800  to 1199
                            [0.8, 0.6, 0.7],  # 1200 to 1599
                            [0.8, 0.9, 0.7],  # 1600 to end
                        ],
                        "changePoints": [
                            int(0    * horizon / 5),
                            int(1    * horizon / 5),
                            int(2    * horizon / 5),
                            int(3    * horizon / 5),
                            int(4    * horizon / 5),
                        ],
                    }
                },
                # envId = 3
                {   # A simple piece-wise stationary problem
                    "env_type" : "Others",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.9, 0.5, 0.4],  # 0    to 399
                            [0.7, 0.4, 0.5],  # 400  to 799
                            [0.5, 0.3, 0.6],  # 800  to 1199
                            [0.3, 0.2, 0.7],  # 1200 to 1599
                            [0.1, 0.1, 0.8],  # 1600 to end
                        ],
                        "changePoints": [
                            int(0    * horizon / 5),
                            int(1    * horizon / 5),
                            int(2    * horizon / 5),
                            int(3    * horizon / 5),
                            int(4    * horizon / 5),
                        ],
                    }
                },
                # envId = 4
                {   # A simple piece-wise stationary problem
                    # "env_type" : "Type-II",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "env_type" : "Type-II",
                    "params": {
                        "listOfMeans": [
                            [0.5, 0.8],  # 0    to 399
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.8],  # 0    to 399
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.8],  # 0    to 399
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.8],  # 0    to 399
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                            [0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.8],  # 1600 to end
                            [0.5, 0.2],  # 400  to 799
                            [0.5, 0.8],  # 800  to 1199
                        ],
                        "changePoints": [
                            int(0    * horizon / 40),
                            int(1    * horizon / 40),
                            int(2    * horizon / 40),
                            int(3    * horizon / 40),
                            int(4    * horizon / 40),
                            int(5    * horizon / 40),
                            int(6    * horizon / 40),
                            int(7    * horizon / 40),
                            int(8    * horizon / 40),
                            int(9    * horizon / 40),
                            int(10    * horizon / 40),
                            int(11    * horizon / 40),
                            int(12    * horizon / 40),
                            int(13    * horizon / 40),
                            int(14    * horizon / 40),
                            int(15    * horizon / 40),
                            int(16    * horizon / 40),
                            int(17    * horizon / 40),
                            int(18    * horizon / 40),
                            int(19    * horizon / 40),
                            int(20    * horizon / 40),
                            int(21    * horizon / 40),
                            int(22    * horizon / 40),
                            int(23    * horizon / 40),
                            int(24    * horizon / 40),
                            int(25    * horizon / 40),
                            int(26    * horizon / 40),
                            int(27    * horizon / 40),
                            int(28    * horizon / 40),
                            int(29    * horizon / 40),
                            int(30    * horizon / 40),
                            int(31    * horizon / 40),
                            int(32    * horizon / 40),
                            int(33    * horizon / 40),
                            int(34    * horizon / 40),
                            int(35    * horizon / 40),
                            int(36    * horizon / 40),
                            int(37    * horizon / 40),
                            int(38    * horizon / 40),
                            int(39    * horizon / 40),
                        ],
                    }
                },
                # envId = 5
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.8, 0.5, 0.2],  # 0    to 399
                            [0.5, 0.2, 0.8],  # 400  to 799
                            [0.2, 0.8, 0.5],  # 800  to 1199
                            [0.8, 0.5, 0.2],  # 1200 to 1599
                            [0.5, 0.2, 0.8],  # 1600 to end
                        ],
                        "changePoints": [
                            int(0    * horizon / 5),
                            int(1    * horizon / 5),
                            int(2    * horizon / 5),
                            int(3    * horizon / 5),
                            int(4    * horizon / 5),
                        ],
                    }
                },
                # envId = 6
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                        ],
                        "changePoints": [
                            int(0    * horizon / 5),
                            int(1    * horizon / 5),
                            int(2    * horizon / 5),
                            int(3    * horizon / 5),
                            int(4    * horizon / 5),
                        ],
                    }
                },
                # envId = 7
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                        ],
                        "changePoints": [
                            int(0    * horizon / 10),
                            int(1    * horizon / 10),
                            int(2    * horizon / 10),
                            int(3    * horizon / 10),
                            int(4    * horizon / 10),
                            int(5    * horizon / 10),
                            int(6    * horizon / 10),
                            int(7    * horizon / 10),
                            int(8    * horizon / 10),
                            int(9    * horizon / 10),
                        ],
                    }
                },
                # envId = 8
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                        ],
                        "changePoints": [
                            int(0    * horizon / 20),
                            int(1    * horizon / 20),
                            int(2    * horizon / 20),
                            int(3    * horizon / 20),
                            int(4    * horizon / 20),
                            int(5    * horizon / 20),
                            int(6    * horizon / 20),
                            int(7    * horizon / 20),
                            int(8    * horizon / 20),
                            int(9    * horizon / 20),
                            int(10    * horizon / 20),
                            int(11    * horizon / 20),
                            int(12    * horizon / 20),
                            int(13    * horizon / 20),
                            int(14    * horizon / 20),
                            int(15    * horizon / 20),
                            int(16    * horizon / 20),
                            int(17    * horizon / 20),
                            int(18    * horizon / 20),
                            int(19    * horizon / 20),
                        ],
                    }
                },
                # envId = 9
                {   # A very hard piece-wise stationary problem, with 6 arms and 9 change points
                    # "arm_type": Bernoulli,
                    "env_type" : "3",
                    "params": {
                    "listOfMeans": [
                        # red, green, blue, yellow, cyan, red dotted
                        [0.71, 0.41, 0.32, 0.30, 0.20, 0.11],  # 1st segment
                        [0.55, 0.53, 0.32, 0.30, 0.08, 0.11],  # 2nd segment
                        [0.40, 0.63, 0.32, 0.30, 0.08, 0.11],  # 3th segment
                        [0.40, 0.42, 0.43, 0.30, 0.08, 0.11],  # 4th segment
                        [0.30, 0.32, 0.55, 0.30, 0.08, 0.11],  # 5th segment
                        [0.30, 0.32, 0.20, 0.30, 0.08, 0.21],  # 6th segment
                        [0.20, 0.22, 0.20, 0.45, 0.08, 0.21],  # 7th segment
                        [0.20, 0.22, 0.20, 0.57, 0.08, 0.11],  # 8th segment
                        [0.20, 0.22, 0.34, 0.57, 0.22, 0.11],  # 9th segment
                    ],
                    "changePoints": np.linspace(0, horizon, num=9, endpoint=False, dtype=int),
                    }
                },
                # envId = 10
                {   # A very hard piece-wise stationary problem, with 6 arms and 9 change points
                    # "arm_type": Bernoulli,
                    "env_type" : "3",
                    "params": {
                    "listOfMeans": [
                        # red, green, blue, yellow, cyan, red dotted
                        [0.071, 0.041, 0.032, 0.030, 0.020, 0.011],  # 1st segment
                        [0.055, 0.053, 0.032, 0.030, 0.008, 0.011],  # 2nd segment
                        [0.040, 0.063, 0.032, 0.030, 0.008, 0.011],  # 3th segment
                        [0.040, 0.042, 0.043, 0.030, 0.008, 0.011],  # 4th segment
                        [0.030, 0.032, 0.055, 0.030, 0.008, 0.011],  # 5th segment
                        [0.030, 0.032, 0.020, 0.030, 0.008, 0.021],  # 6th segment
                        [0.020, 0.022, 0.020, 0.045, 0.008, 0.021],  # 7th segment
                        [0.020, 0.022, 0.020, 0.057, 0.008, 0.011],  # 8th segment
                        [0.020, 0.022, 0.034, 0.057, 0.022, 0.011],  # 9th segment
                    ],
                    "changePoints": np.linspace(0, horizon, num=9, endpoint=False, dtype=int),
                    }
                },
                # envId = 11
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                        ],
                        "changePoints": [
                            int(0    * horizon / 5),
                            int(1    * horizon / 5),
                            int(2    * horizon / 5),
                        ],
                    }
                },
                # envId = 12
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.8, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],  
                            [0.5, 0.6, 0.4],  
                            [0.5, 0.4, 0.6],  
                            [0.8, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],  
                            [0.5, 0.6, 0.4],  
                            [0.5, 0.4, 0.6],                          
                        ],
                        "changePoints": [
                            int(0    * horizon / 8),
                            int(1    * horizon / 8),
                            int(2    * horizon / 8),
                            int(3    * horizon / 8),
                            int(4    * horizon / 8),
                            int(5    * horizon / 8),
                            int(6    * horizon / 8),
                            int(7    * horizon / 8),
                        ],
                    }
                },
                # envId = 13
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.8, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],  
                            [0.2, 0.6, 0.4],  
                            [0.2, 0.4, 0.6],  
                            [0.8, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],  
                            [0.2, 0.6, 0.4],  
                            [0.2, 0.4, 0.6],                          
                        ],
                        "changePoints": [
                            int(0    * horizon / 8),
                            int(1    * horizon / 8),
                            int(2    * horizon / 8),
                            int(3    * horizon / 8),
                            int(4    * horizon / 8),
                            int(5    * horizon / 8),
                            int(6    * horizon / 8),
                            int(7    * horizon / 8),
                        ],
                    }
                },
                # envId = 14
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.8, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],  
                            [0.5, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],  
                            [0.8, 0.6, 0.4],  
                            [0.5, 0.4, 0.6],  
                            [0.8, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],      
                            [0.5, 0.6, 0.4],                    
                        ],
                        "changePoints": [
                            int(0    * horizon / 9),
                            int(1    * horizon / 9),
                            int(2    * horizon / 9),
                            int(3    * horizon / 9),
                            int(4    * horizon / 9),
                            int(5    * horizon / 9),
                            int(6    * horizon / 9),
                            int(7    * horizon / 9),
                            int(8    * horizon / 9),
                        ],
                    }
                },
                # envId = 15
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.8, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],  
                            [0.8, 0.6, 0.4],  
                            [0.5, 0.4, 0.6],  
                            [0.8, 0.6, 0.4],  
                            [0.8, 0.4, 0.6],  
                            [0.8, 0.6, 0.4],  
                            [0.5, 0.4, 0.6],                          
                        ],
                        "changePoints": [
                            int(0    * horizon / 8),
                            int(1    * horizon / 8),
                            int(2    * horizon / 8),
                            int(3    * horizon / 8),
                            int(4    * horizon / 8),
                            int(5    * horizon / 8),
                            int(6    * horizon / 8),
                            int(7    * horizon / 8),
                        ],
                    }
                },
                # envId = 16
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                        ],
                        "changePoints": [
                            int(0 * horizon / 50),
                            int(1 * horizon / 50),
                            int(2 * horizon / 50),
                            int(3 * horizon / 50),
                            int(4 * horizon / 50),
                            int(5 * horizon / 50),
                            int(6 * horizon / 50),
                            int(7 * horizon / 50),
                            int(8 * horizon / 50),
                            int(9 * horizon / 50),
                            int(10 * horizon / 50),
                            int(11 * horizon / 50),
                            int(12 * horizon / 50),
                            int(13 * horizon / 50),
                            int(14 * horizon / 50),
                            int(15 * horizon / 50),
                            int(16 * horizon / 50),
                            int(17 * horizon / 50),
                            int(18 * horizon / 50),
                            int(19 * horizon / 50),
                            int(20 * horizon / 50),
                            int(21 * horizon / 50),
                            int(22 * horizon / 50),
                            int(23 * horizon / 50),
                            int(24 * horizon / 50),
                            int(25 * horizon / 50),
                            int(26 * horizon / 50),
                            int(27 * horizon / 50),
                            int(28 * horizon / 50),
                            int(29 * horizon / 50),
                            int(30 * horizon / 50),
                            int(31 * horizon / 50),
                            int(32 * horizon / 50),
                            int(33 * horizon / 50),
                            int(34 * horizon / 50),
                            int(35 * horizon / 50),
                            int(36 * horizon / 50),
                            int(37 * horizon / 50),
                            int(38 * horizon / 50),
                            int(39 * horizon / 50),
                            int(40 * horizon / 50),
                            int(41 * horizon / 50),
                            int(42 * horizon / 50),
                            int(43 * horizon / 50),
                            int(44 * horizon / 50),
                            int(45 * horizon / 50),
                            int(46 * horizon / 50),
                            int(47 * horizon / 50),
                            int(48 * horizon / 50),
                            int(49 * horizon / 50),
                        ],

                    }
                },
                # envId = 17
                {   # A simple piece-wise stationary problem
                    "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                    "params": {
                        "listOfMeans": [
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                            [0.2, 0.5, 0.8],  # 0    to 399
                            [0.5, 0.8, 0.2],  # 400  to 799
                            [0.8, 0.2, 0.5],  # 800  to 1199
                            [0.2, 0.5, 0.8],  # 1200 to 1599
                            [0.5, 0.8, 0.2],  # 1600 to end
                        ],
                        "changePoints": [
                            int(0 * horizon / 100),
                            int(1 * horizon / 100),
                            int(2 * horizon / 100),
                            int(3 * horizon / 100),
                            int(4 * horizon / 100),
                            int(5 * horizon / 100),
                            int(6 * horizon / 100),
                            int(7 * horizon / 100),
                            int(8 * horizon / 100),
                            int(9 * horizon / 100),
                            int(10 * horizon / 100),
                            int(11 * horizon / 100),
                            int(12 * horizon / 100),
                            int(13 * horizon / 100),
                            int(14 * horizon / 100),
                            int(15 * horizon / 100),
                            int(16 * horizon / 100),
                            int(17 * horizon / 100),
                            int(18 * horizon / 100),
                            int(19 * horizon / 100),
                            int(20 * horizon / 100),
                            int(21 * horizon / 100),
                            int(22 * horizon / 100),
                            int(23 * horizon / 100),
                            int(24 * horizon / 100),
                            int(25 * horizon / 100),
                            int(26 * horizon / 100),
                            int(27 * horizon / 100),
                            int(28 * horizon / 100),
                            int(29 * horizon / 100),
                            int(30 * horizon / 100),
                            int(31 * horizon / 100),
                            int(32 * horizon / 100),
                            int(33 * horizon / 100),
                            int(34 * horizon / 100),
                            int(35 * horizon / 100),
                            int(36 * horizon / 100),
                            int(37 * horizon / 100),
                            int(38 * horizon / 100),
                            int(39 * horizon / 100),
                            int(40 * horizon / 100),
                            int(41 * horizon / 100),
                            int(42 * horizon / 100),
                            int(43 * horizon / 100),
                            int(44 * horizon / 100),
                            int(45 * horizon / 100),
                            int(46 * horizon / 100),
                            int(47 * horizon / 100),
                            int(48 * horizon / 100),
                            int(49 * horizon / 100),
                            int(50 * horizon / 100),
                            int(51 * horizon / 100),
                            int(52 * horizon / 100),
                            int(53 * horizon / 100),
                            int(54 * horizon / 100),
                            int(55 * horizon / 100),
                            int(56 * horizon / 100),
                            int(57 * horizon / 100),
                            int(58 * horizon / 100),
                            int(59 * horizon / 100),
                            int(60 * horizon / 100),
                            int(61 * horizon / 100),
                            int(62 * horizon / 100),
                            int(63 * horizon / 100),
                            int(64 * horizon / 100),
                            int(65 * horizon / 100),
                            int(66 * horizon / 100),
                            int(67 * horizon / 100),
                            int(68 * horizon / 100),
                            int(69 * horizon / 100),
                            int(70 * horizon / 100),
                            int(71 * horizon / 100),
                            int(72 * horizon / 100),
                            int(73 * horizon / 100),
                            int(74 * horizon / 100),
                            int(75 * horizon / 100),
                            int(76 * horizon / 100),
                            int(77 * horizon / 100),
                            int(78 * horizon / 100),
                            int(79 * horizon / 100),
                            int(80 * horizon / 100),
                            int(81 * horizon / 100),
                            int(82 * horizon / 100),
                            int(83 * horizon / 100),
                            int(84 * horizon / 100),
                            int(85 * horizon / 100),
                            int(86 * horizon / 100),
                            int(87 * horizon / 100),
                            int(88 * horizon / 100),
                            int(89 * horizon / 100),
                            int(90 * horizon / 100),
                            int(91 * horizon / 100),
                            int(92 * horizon / 100),
                            int(93 * horizon / 100),
                            int(94 * horizon / 100),
                            int(95 * horizon / 100),
                            int(96 * horizon / 100),
                            int(97 * horizon / 100),
                            int(98 * horizon / 100),
                            int(99 * horizon / 100),
                        ],

                    }
                },
            ]
        return ENVIRONMENTS[envId]
    else:
        ENVIRONMENTS = {   # A simple piece-wise stationary problem
                "env_type" : "rand",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                "listOfMeans": [
                    [round(np.random.rand(),2) ,round(np.random.rand(),2) ,round(np.random.rand(),2)],  # 0    to 399
                    [round(np.random.rand(),2) ,round(np.random.rand(),2) ,round(np.random.rand(),2)],  # 400  to 799
                    [round(np.random.rand(),2) ,round(np.random.rand(),2) ,round(np.random.rand(),2)],  # 800  to 1199
                    [round(np.random.rand(),2) ,round(np.random.rand(),2) ,round(np.random.rand(),2)],  # 1200 to 1599
                    [round(np.random.rand(),2) ,round(np.random.rand(),2) ,round(np.random.rand(),2)],  # 1600 to end
                ],
                "changePoints": [
                    int(0    * horizon / 5),
                    int(1    * horizon / 5),
                    int(2    * horizon / 5),
                    int(3    * horizon / 5),
                    int(4    * horizon / 5),
                ],
            }
        }
        return ENVIRONMENTS