import numpy as np

def skip_mech(Z, n, n_for_skip, N_I, action, B):
    hist_sample_mean = np.zeros(np.size(Z,0),dtype = float)
    skip_sample_mean = np.zeros(np.size(Z,0),dtype = float)
    for k in range(np.size(Z,0)):
        hist_sample_mean[k] = np.sum(Z[k][0:n[k]-n_for_skip[k]])/(n[k]-n_for_skip[k])
        skip_sample_mean[k] = np.sum(Z[k][n[k]-n_for_skip[k]:n[k]])/n_for_skip[k]
    k_opt = np.argmax(hist_sample_mean, axis=0)
    if action == k_opt:
        if np.any(n_for_skip >= N_I) and np.any(np.arange(len(n)) != k_opt):  
            k_found = None  
            for k in range(len(n)):
                if k != k_opt and n[k] >= N_I :
                    if k_found == None or n[k]>=n[k_found]:
                        k_found = k
            if k_found!= None:
                if skip_sample_mean[k_opt] < skip_sample_mean[k_found] + B:
                    return False
            else:
                return True
        else:
            return True

    else:
        if n_for_skip[action] >= N_I:
            if skip_sample_mean[k_opt] > skip_sample_mean[action] + B:
                return True
            else:
                return False
            
        else:
            return True
        
def skip_mech_MUCB(Z, n, N_I, action, B):
    hist_sample_mean = np.zeros(np.size(Z,0),dtype = float)
    skip_sample_mean = np.zeros(np.size(Z,0),dtype = float)
    for k in range(np.size(Z,0)):
        if n[k]>=N_I:
            hist_sample_mean[k] = np.sum(Z[k][0:n[k]-int(N_I)])/(n[k]-int(N_I))
            skip_sample_mean[k] = np.sum(Z[k][n[k]-int(N_I):n[k]])/int(N_I)
        else:
            hist_sample_mean[k] = np.sum(Z[k][0:n[k]])/n[k]
            skip_sample_mean[k] = 0
    k_opt = np.argmax(hist_sample_mean, axis=0)
    if action == k_opt:
        if np.any(n >= 2*N_I) and np.any(np.arange(len(n)) != k_opt):  
            k_found = None  
            for k in range(len(n)):
                if k != k_opt and n[k] >= N_I :
                    if k_found == None or n[k]>=n[k_found]:
                        k_found = k
            if k_found!= None:
                if skip_sample_mean[k_opt] < skip_sample_mean[k_found] + B:
                    return False
            else:
                return True
        else:
            return True

    else:
        if n[action] >= 2*N_I:
            if skip_sample_mean[k_opt] > skip_sample_mean[action] + B:
                return True
            else:
                return False
            
        else:
            return True