function DTS(Table,gamma=0.75,a=1,b=1)
    # discount gamma, Beta(a,b) prior 
    (K,T)=size(Table)
    episode=1
    ChangePoints = []
    DiscNumber=zeros(Float32,K) # discounted number of selections 
    DiscSum=zeros(Float32,K) # discounted sum of rewards
    Time =0 # discounted total number of pulls 
    ChosenArms = zeros(Int,T)
    ReceivedRewards = zeros(T)
    for t in 1:T
       # compute KL-UCB indices 
       indices = ones(K)
       for i in 1:K
          if (DiscNumber[i]>0)
             indices[i]=rand(Beta(a+DiscSum[i], b+DiscNumber[i]-DiscSum[i]), 1)[1]
          end
       end
       I = randmax(indices)
       # get the reward  
       rew = Table[I,t]
       ChosenArms[t]=I 
       ReceivedRewards[t]=rew
       # update everything
       DiscNumber = gamma*DiscNumber
       DiscNumber[I]+=1
       DiscSum = gamma*DiscSum
       DiscSum[I]+=rew
       Time = 1+gamma*Time
    end
    return ChosenArms,ReceivedRewards,episode,ChangePoints
 end