import numpy as np
from Environment import Environment
from MUCB import MUCB
from CUSUM_UCB import CusumUCB
from GLR_UCB import GLRUCB
from klUCB import klUCB
from Oracle_klUCB import OracleklUCB
from DTS import DTS
from DklUCB import DklUCB
from AdSwitch import AdSwitch
from ArmSwitch import ArmSwitch
from META import Meta
from Master import Master
from plot import Plot
import os, os.path
import matplotlib.pyplot as mpl
from generate_instance import Regret_versus_K


HORIZON = 20000
REPETITIONS = 50
PLOT_DIR = "C:/Users/USER/Code/SimulatuionByMe/plot"
NB_SEGS = 5
NB_OF_INSTANCES = 100


class main(object):
    def __init__(self, experiment = None, horizon = HORIZON, repetitions = REPETITIONS, envId = 0, nb_of_instances = NB_OF_INSTANCES, ID = 0):
        
        ENVIRONMENTS = [ 
            # envId = 0
            {   # A simple piece-wise stationary problem
                "env_type" : "Others",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                    "listOfMeans": [
                        [0.9, 0.5, 0.2],  # 0    to 399
                        [0.9, 0.2, 0.2],  # 400  to 799
                        [0.1, 0.2, 0.2],  # 800  to 1199
                        [0.1, 0.7, 0.2],  # 1200 to 1599
                        [0.1, 0.7, 0.5],  # 1600 to end
                    ],
                    "changePoints": [
                        int(0    * horizon / 5),
                        int(1    * horizon / 5),
                        int(2    * horizon / 5),
                        int(3    * horizon / 5),
                        int(4    * horizon / 5),
                    ],
                }
            },
            # envId = 1
            {   # A simple piece-wise stationary problem
                "env_type" : "Type-II",
                "params": {
                    "listOfMeans": [
                        [0.5, 0.8],  # 0    to 399
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                    ],
                    "changePoints": [
                        int(0    * horizon / 5),
                        int(1    * horizon / 5),
                        int(2    * horizon / 5),
                        int(3    * horizon / 5),
                        int(4    * horizon / 5),
                    ],
                }
            },
            # envId = 2
            {   # A simple piece-wise stationary problem
                "env_type" : "Others",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                    "listOfMeans": [
                        [0.5, 0.2, 0.3],  # 0    to 399
                        [0.5, 0.6, 0.3],  # 400  to 799
                        [0.5, 0.6, 0.7],  # 800  to 1199
                        [0.8, 0.6, 0.7],  # 1200 to 1599
                        [0.8, 0.9, 0.7],  # 1600 to end
                    ],
                    "changePoints": [
                        int(0    * horizon / 5),
                        int(1    * horizon / 5),
                        int(2    * horizon / 5),
                        int(3    * horizon / 5),
                        int(4    * horizon / 5),
                    ],
                }
            },
            # envId = 3
            {   # A simple piece-wise stationary problem
                "env_type" : "Others",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                    "listOfMeans": [
                        [0.9, 0.5, 0.4],  # 0    to 399
                        [0.7, 0.4, 0.5],  # 400  to 799
                        [0.5, 0.3, 0.6],  # 800  to 1199
                        [0.3, 0.2, 0.7],  # 1200 to 1599
                        [0.1, 0.1, 0.8],  # 1600 to end
                    ],
                    "changePoints": [
                        int(0    * horizon / 5),
                        int(1    * horizon / 5),
                        int(2    * horizon / 5),
                        int(3    * horizon / 5),
                        int(4    * horizon / 5),
                    ],
                }
            },
            # envId = 4
            {   # A simple piece-wise stationary problem
                # "env_type" : "Type-II",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "env_type" : "Type-II",
                "params": {
                    "listOfMeans": [
                        [0.5, 0.8],  # 0    to 399
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.8],  # 0    to 399
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.8],  # 0    to 399
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.8],  # 0    to 399
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                        [0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.8],  # 1600 to end
                        [0.5, 0.2],  # 400  to 799
                        [0.5, 0.8],  # 800  to 1199
                    ],
                    "changePoints": [
                        int(0    * horizon / 40),
                        int(1    * horizon / 40),
                        int(2    * horizon / 40),
                        int(3    * horizon / 40),
                        int(4    * horizon / 40),
                        int(5    * horizon / 40),
                        int(6    * horizon / 40),
                        int(7    * horizon / 40),
                        int(8    * horizon / 40),
                        int(9    * horizon / 40),
                        int(10    * horizon / 40),
                        int(11    * horizon / 40),
                        int(12    * horizon / 40),
                        int(13    * horizon / 40),
                        int(14    * horizon / 40),
                        int(15    * horizon / 40),
                        int(16    * horizon / 40),
                        int(17    * horizon / 40),
                        int(18    * horizon / 40),
                        int(19    * horizon / 40),
                        int(20    * horizon / 40),
                        int(21    * horizon / 40),
                        int(22    * horizon / 40),
                        int(23    * horizon / 40),
                        int(24    * horizon / 40),
                        int(25    * horizon / 40),
                        int(26    * horizon / 40),
                        int(27    * horizon / 40),
                        int(28    * horizon / 40),
                        int(29    * horizon / 40),
                        int(30    * horizon / 40),
                        int(31    * horizon / 40),
                        int(32    * horizon / 40),
                        int(33    * horizon / 40),
                        int(34    * horizon / 40),
                        int(35    * horizon / 40),
                        int(36    * horizon / 40),
                        int(37    * horizon / 40),
                        int(38    * horizon / 40),
                        int(39    * horizon / 40),
                    ],
                }
            },
            # envId = 5
            {   # A simple piece-wise stationary problem
                "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                    "listOfMeans": [
                        [0.8, 0.5, 0.2],  # 0    to 399
                        [0.5, 0.2, 0.8],  # 400  to 799
                        [0.2, 0.8, 0.5],  # 800  to 1199
                        [0.8, 0.5, 0.2],  # 1200 to 1599
                        [0.5, 0.2, 0.8],  # 1600 to end
                    ],
                    "changePoints": [
                        int(0    * horizon / 5),
                        int(1    * horizon / 5),
                        int(2    * horizon / 5),
                        int(3    * horizon / 5),
                        int(4    * horizon / 5),
                    ],
                }
            },
            # envId = 6
            {   # A simple piece-wise stationary problem
                "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                    "listOfMeans": [
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.8, 0.2, 0.5],  # 800  to 1199
                        [0.2, 0.5, 0.8],  # 1200 to 1599
                        [0.5, 0.8, 0.2],  # 1600 to end
                    ],
                    "changePoints": [
                        int(0    * horizon / 5),
                        int(1    * horizon / 5),
                        int(2    * horizon / 5),
                        int(3    * horizon / 5),
                        int(4    * horizon / 5),
                    ],
                }
            },
            # envId = 7
            {   # A simple piece-wise stationary problem
                "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                    "listOfMeans": [
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.8, 0.2, 0.5],  # 800  to 1199
                        [0.2, 0.5, 0.8],  # 1200 to 1599
                        [0.5, 0.8, 0.2],  # 1600 to end
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.8, 0.2, 0.5],  # 800  to 1199
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                    ],
                    "changePoints": [
                        int(0    * horizon / 10),
                        int(1    * horizon / 10),
                        int(2    * horizon / 10),
                        int(3    * horizon / 10),
                        int(4    * horizon / 10),
                        int(5    * horizon / 10),
                        int(6    * horizon / 10),
                        int(7    * horizon / 10),
                        int(8    * horizon / 10),
                        int(9    * horizon / 10),
                    ],
                }
            },
            # envId = 8
            {   # A simple piece-wise stationary problem
                "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                    "listOfMeans": [
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.8, 0.2, 0.5],  # 800  to 1199
                        [0.2, 0.5, 0.8],  # 1200 to 1599
                        [0.5, 0.8, 0.2],  # 1600 to end
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.8, 0.2, 0.5],  # 800  to 1199
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.8, 0.2, 0.5],  # 800  to 1199
                        [0.2, 0.5, 0.8],  # 1200 to 1599
                        [0.5, 0.8, 0.2],  # 1600 to end
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.8, 0.2, 0.5],  # 800  to 1199
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                    ],
                    "changePoints": [
                        int(0    * horizon / 20),
                        int(1    * horizon / 20),
                        int(2    * horizon / 20),
                        int(3    * horizon / 20),
                        int(4    * horizon / 20),
                        int(5    * horizon / 20),
                        int(6    * horizon / 20),
                        int(7    * horizon / 20),
                        int(8    * horizon / 20),
                        int(9    * horizon / 20),
                        int(10    * horizon / 20),
                        int(11    * horizon / 20),
                        int(12    * horizon / 20),
                        int(13    * horizon / 20),
                        int(14    * horizon / 20),
                        int(15    * horizon / 20),
                        int(16    * horizon / 20),
                        int(17    * horizon / 20),
                        int(18    * horizon / 20),
                        int(19    * horizon / 20),
                    ],
                }
            },
            # envId = 9
            {   # A very hard piece-wise stationary problem, with 6 arms and 9 change points
                # "arm_type": Bernoulli,
                "env_type" : "3",
                "params": {
                "listOfMeans": [
                    # red, green, blue, yellow, cyan, red dotted
                    [0.71, 0.41, 0.32, 0.30, 0.20, 0.11],  # 1st segment
                    [0.55, 0.53, 0.32, 0.30, 0.08, 0.11],  # 2nd segment
                    [0.40, 0.63, 0.32, 0.30, 0.08, 0.11],  # 3th segment
                    [0.40, 0.42, 0.43, 0.30, 0.08, 0.11],  # 4th segment
                    [0.30, 0.32, 0.55, 0.30, 0.08, 0.11],  # 5th segment
                    [0.30, 0.32, 0.20, 0.30, 0.08, 0.21],  # 6th segment
                    [0.20, 0.22, 0.20, 0.45, 0.08, 0.21],  # 7th segment
                    [0.20, 0.22, 0.20, 0.57, 0.08, 0.11],  # 8th segment
                    [0.20, 0.22, 0.34, 0.57, 0.22, 0.11],  # 9th segment
                ],
                "changePoints": np.linspace(0, horizon, num=9, endpoint=False, dtype=int),
                }
            },
            # envId = 10
            {   # A very hard piece-wise stationary problem, with 6 arms and 9 change points
                # "arm_type": Bernoulli,
                "env_type" : "3",
                "params": {
                "listOfMeans": [
                    # red, green, blue, yellow, cyan, red dotted
                    [0.071, 0.041, 0.032, 0.030, 0.020, 0.011],  # 1st segment
                    [0.055, 0.053, 0.032, 0.030, 0.008, 0.011],  # 2nd segment
                    [0.040, 0.063, 0.032, 0.030, 0.008, 0.011],  # 3th segment
                    [0.040, 0.042, 0.043, 0.030, 0.008, 0.011],  # 4th segment
                    [0.030, 0.032, 0.055, 0.030, 0.008, 0.011],  # 5th segment
                    [0.030, 0.032, 0.020, 0.030, 0.008, 0.021],  # 6th segment
                    [0.020, 0.022, 0.020, 0.045, 0.008, 0.021],  # 7th segment
                    [0.020, 0.022, 0.020, 0.057, 0.008, 0.011],  # 8th segment
                    [0.020, 0.022, 0.034, 0.057, 0.022, 0.011],  # 9th segment
                ],
                "changePoints": np.linspace(0, horizon, num=9, endpoint=False, dtype=int),
                }
            },
            # envId = 11
            {   # A simple piece-wise stationary problem
                "env_type" : "3",  # "Type-I" = 2 arm switch, "Type-II" = 1 arm switch 1 arm constant, "Others"
                "params": {
                    "listOfMeans": [
                        [0.2, 0.5, 0.8],  # 0    to 399
                        [0.5, 0.8, 0.2],  # 400  to 799
                        [0.8, 0.2, 0.5],  # 800  to 1199
                    ],
                    "changePoints": [
                        int(0    * horizon / 5),
                        int(1    * horizon / 5),
                        int(2    * horizon / 5),
                    ],
                }
            },
        ]
        
        ENVIRONMENTS[envId]["params"]["listOfMeans"][1]
        nb_arms = len(ENVIRONMENTS[envId]["params"]["listOfMeans"][0])
        print("==> Using K = {} arms".format(nb_arms))
        nb_break_point = len(ENVIRONMENTS[envId]["params"]["changePoints"])
        print("==> Using Upsilon_T = {} change points".format(nb_break_point))

        print("==> Using the following {} change points".format(list(ENVIRONMENTS[envId]["params"]["changePoints"])))
        
        configuration = {
            # --- Duration of the experiment
            "horizon": horizon,
            # --- Number of repetition of the experiment (to have an average)
            "repetitions": repetitions,
            # --- Parameters for the use of joblib.Parallel
            # "n_jobs": N_JOBS,    # = nb of CPU cores
            "verbosity": 0,      # Max joblib verbosity
            # --- Arms
            "environment": ENVIRONMENTS[envId],
            # --- Algorithms
            # "policies": POLICIES,
            "nb_arms": nb_arms,
            # --- Random events
            "nb_break_points": nb_break_point,
            # --- Should we plot the lower-bounds or not?
            "plot_lowerbound": False,  # XXX Default
        }
    
        if experiment == "M":
            subfolder = "/SP__K{}_T{}_N{}_M_scaling_envId{}".format(nb_arms, horizon, repetitions, envId)
        elif experiment == "K":
            subfolder = "/SP__M{}_T{}_N{}_K_scaling_envId{}_nbOfins{}_ID{}".format(nb_break_point, horizon, repetitions, envId, nb_of_instances, ID)
        elif experiment == "T":
            subfolder = "/SP__M{}_K{}_N{}_T_scaling_envId{}".format(nb_break_point, nb_arms, repetitions, envId)
        else:
            subfolder = "/SP__K{}_T{}_N{}_M{}_envId{}".format(nb_arms, horizon, repetitions, nb_break_point, envId)

        plot_dir = PLOT_DIR + subfolder

        # Create the sub folder
        if os.path.isdir(plot_dir):
            print("{} is already a directory here...".format(plot_dir))
        elif os.path.isfile(plot_dir):
            raise ValueError("[ERROR] {} is a file, cannot use it as a directory !".format(plot_dir))
        else:
            os.mkdir(plot_dir)
        print("Using sub folder = '{}' and plotting in '{}'...".format(subfolder, plot_dir))
        
        if experiment == "M":
            file = plot_dir + "/Regrets_versus_M_file_name.txt"
            if os.path.isfile(file):
                print("Delete the existing file...")
                os.remove(file)

            env = Environment(configuration, experiment=experiment, repetitions=repetitions, path = plot_dir)
            DTS(configuration, ENV = env, path = plot_dir)
            DklUCB(configuration, ENV = env, path = plot_dir)
            MUCB_dimi = MUCB(configuration,ENV=env, gamma = 'd', alpha = 1, w = 200, path = plot_dir)#, klUCB=True)
            MUCB_ = MUCB(configuration, ENV=env,  w = 200, path = plot_dir, gamma = None)#, klUCB=True)
            GLR_unknownchange = GLRUCB(configuration,ENV=env,subSample=10 , path = plot_dir)#, klUCB=True)
            GLRUCB(configuration, ENV=env, subSample=10 , path = plot_dir, diminishing = True)
            # ArmSwitch(configuration,ENV=env,path = plot_dir)
            # AdSwitch(configuration,ENV=env,path = plot_dir)
            # Meta(configuration,ENV=env,path = plot_dir)
            Master(configuration,ENV=env,path = plot_dir)
            CUSUM = CusumUCB(configuration, ENV=env, max_nb_random_events = None, gamma = None,  alpha=None, epslion = None,  path = plot_dir)#, klUCB = True)
            CUSUM_dimi = CusumUCB(configuration, ENV=env, max_nb_random_events = None, gamma = "d",  alpha=1, epslion = None,  path = plot_dir)#, klUCB = True)

        elif experiment == "K":
            file = plot_dir + "/Regrets_versus_K_file_name.txt"
            if os.path.isfile(file):
                print("Delete the existing file...")
                os.remove(file)

            Instance = Regret_versus_K(horizon = HORIZON, nb_segs = NB_SEGS, nb_of_instances = nb_of_instances, repetitions = repetitions)
            ENVIRONMENTS = Instance.ENVIRONMENTS
            configuration = []
            for envId in range(len(ENVIRONMENTS)):
                ENVIRONMENTS[envId]["params"]["listOfMeans"][1]
                nb_arms = len(ENVIRONMENTS[envId]["params"]["listOfMeans"][0])
                print("==> Using K = {} arms".format(nb_arms))
                nb_break_point = len(ENVIRONMENTS[envId]["params"]["changePoints"])
                print("==> Using Upsilon_T = {} change points".format(nb_break_point))

                print("==> Using the following {} change points".format(list(ENVIRONMENTS[envId]["params"]["changePoints"])))
                configuration = configuration + [{
                # --- Duration of the experiment
                "horizon": horizon,
                # --- Number of repetition of the experiment (to have an average)
                "repetitions": repetitions,
                # --- Parameters for the use of joblib.Parallel
                # "n_jobs": N_JOBS,    # = nb of CPU cores
                "verbosity": 0,      # Max joblib verbosity
                # --- Arms
                "environment": ENVIRONMENTS[envId],
                # --- Algorithms
                # "policies": POLICIES,
                "nb_arms": nb_arms,
                # --- Random events
                "nb_break_points": nb_break_point,
                # --- Should we plot the lower-bounds or not?
                "plot_lowerbound": False,  # XXX Default
            }]

            env = Environment(configuration, experiment=experiment, repetitions=repetitions, path = plot_dir)
            DTS(configuration, ENV = env, path = plot_dir)
            DklUCB(configuration, ENV = env, path = plot_dir)
            MUCB_dimi = MUCB(configuration,ENV=env, gamma = 'd', alpha = 1, w = 200, path = plot_dir)#, klUCB=True)
            MUCB_ = MUCB(configuration, ENV=env,  w = 200, path = plot_dir, gamma = None)#, klUCB=True)
            GLR_unknownchange = GLRUCB(configuration,ENV=env,subSample=10 , path = plot_dir)#, klUCB=True)
            GLRUCB(configuration, ENV=env, subSample=10 , path = plot_dir, diminishing = True)
            # ArmSwitch(configuration,ENV=env,path = plot_dir)
            # AdSwitch(configuration,ENV=env,path = plot_dir)
            # Meta(configuration,ENV=env,path = plot_dir)
            Master(configuration,ENV=env,path = plot_dir)
            CUSUM = CusumUCB(configuration, ENV=env, max_nb_random_events = None, gamma = None,  alpha=None, epslion = None,  path = plot_dir)#, klUCB = True)
            CUSUM_dimi = CusumUCB(configuration, ENV=env, max_nb_random_events = None, gamma = "d",  alpha=1, epslion = None,  path = plot_dir)#, klUCB = True)

        elif experiment == "T":
            file = plot_dir + "/Regrets_versus_T_file_name.txt"
            if os.path.isfile(file):
                print("Delete the existing file...")
                os.remove(file)

            env = Environment(configuration, experiment=experiment, repetitions=repetitions, path = plot_dir)
            # DTS(configuration, ENV = env, path = plot_dir)
            # DklUCB(configuration, ENV = env, path = plot_dir)
            # MUCB_dimi = MUCB(configuration,ENV=env, gamma = 'd', alpha = 1, w = 200, path = plot_dir)#, klUCB=True)
            MUCB_ = MUCB(configuration, ENV=env,  w = 200, path = plot_dir, gamma = None)#, klUCB=True)
            # GLR_unknownchange = GLRUCB(configuration,ENV=env,subSample=10 , path = plot_dir)#, klUCB=True)
            # GLRUCB(configuration, ENV=env, subSample=10 , path = plot_dir, diminishing = True)
            # ArmSwitch(configuration,ENV=env,path = plot_dir)
            # AdSwitch(configuration,ENV=env,path = plot_dir)
            # Meta(configuration,ENV=env,path = plot_dir)
            # Master(configuration,ENV=env,path = plot_dir)
            # CUSUM = CusumUCB(configuration, ENV=env, max_nb_random_events = None, gamma = None,  alpha=None, epslion = None,  path = plot_dir)#, klUCB = True)
            # CUSUM_dimi = CusumUCB(configuration, ENV=env, max_nb_random_events = None, gamma = "d",  alpha=1, epslion = None,  path = plot_dir)#, klUCB = True)

        else:
            file = plot_dir + "/Regrets_file_name.txt"
            # 檢查檔案是否存在
            if os.path.isfile(file):
                print("Delete the existing file...")
                os.remove(file)

            file = plot_dir + "/std_Regrets_file_name.txt"
            # 檢查檔案是否存在
            if os.path.isfile(file):
                print("Delete the existing file...")
                os.remove(file)
                
            env = Environment(configuration, experiment=experiment, repetitions=repetitions, path = plot_dir)
            # DTS(configuration, ENV = env, path = plot_dir)
            # DklUCB(configuration, ENV = env, path = plot_dir)
            # MUCB_dimi = MUCB(configuration,ENV=env, gamma = 'd', alpha = 1, w = 200, path = plot_dir)#, klUCB=True)
            # MUCB_ = MUCB(configuration, ENV=env,  w = 200, path = plot_dir, gamma = None)#, klUCB=True)
            # GLR_unknownchange = GLRUCB(configuration, ENV=env, subSample=10 , path = plot_dir)#, klUCB=True)
            GLRUCB(configuration, ENV=env, subSample=10 , path = plot_dir, diminishing = True)#, klUCB=True)
            # ArmSwitch(configuration,ENV=env,path = plot_dir)
            # AdSwitch(configuration,ENV=env,path = plot_dir)
            # Meta(configuration,ENV=env,path = plot_dir)
            # Master(configuration,ENV=env,path = plot_dir)
            # CUSUM = CusumUCB(configuration, ENV=env, max_nb_random_events = None, gamma = None,  alpha=None, epslion = None,  path = plot_dir)#, klUCB = True)
            # CUSUM_dimi = CusumUCB(configuration, ENV=env, max_nb_random_events = None, gamma = "d",  alpha=1, epslion = None,  path = plot_dir)#, klUCB = True)

        
        

        # if experiment != "M" and experiment != "K" and experiment != "T":
        #     kl_UCB = klUCB(configuration,ENV=env, path = plot_dir)
        #     Oracle_klUCB = OracleklUCB(configuration,ENV=env, path = plot_dir)
        

        
        if experiment == "M":
            mainfig = plot_dir + "/main"
            if mainfig is not None: mainfig = "{}__Regret_versus_M".format(mainfig)
            mpl.rcParams['figure.figsize'] = (12,8)
            mpl.rcParams['figure.dpi'] = 200
            plotfig = Plot()
            fig = plotfig.plotLastRegretVersusM(savefig = mainfig, path = plot_dir)
        elif experiment == "K":
            mainfig = plot_dir + "/main"
            if mainfig is not None: mainfig = "{}__Regret_versus_K".format(mainfig)
            mpl.rcParams['figure.figsize'] = (12,8)
            mpl.rcParams['figure.dpi'] = 200
            plotfig = Plot()
            fig = plotfig.plotLastRegretVersusK(savefig = mainfig, path = plot_dir)
        elif experiment == "T":
            mainfig = plot_dir + "/main"
            if mainfig is not None: mainfig = "{}__Regret_versus_T".format(mainfig)
            mpl.rcParams['figure.figsize'] = (12,8)
            mpl.rcParams['figure.dpi'] = 200
            plotfig = Plot()
            fig = plotfig.plotLastRegretVersusT(savefig = mainfig, path = plot_dir)
        else:  
            mpl.rcParams['figure.dpi'] = 100
            mpl.rcParams['figure.figsize'] = (20,10)
            mainfig = plot_dir + "/main"
            if mainfig is not None: mainfig = "{}__Regret".format(mainfig)
            mpl.rcParams['figure.figsize'] = (12,8)
            mpl.rcParams['figure.dpi'] = 200
            plotfig = Plot()
            fig = plotfig.plotMyRegret(savefig = mainfig, path = plot_dir)
        
if __name__ == '__main__':
    # experiment = None, horizon = HORIZON, repetitions = REPETITIONS, envId = 0,  path = None
    # main(experiment = None, horizon = 20000, repetitions = 100, envId = 0)
    # main(experiment = None, horizon = 20000, repetitions = 100, envId = 3)
    # main(experiment = None, horizon = 20000, repetitions = 100, envId = 1)
    # main(experiment = None, horizon = 20000, repetitions = 100, envId = 4)
    # main(experiment = None, horizon = 20000, repetitions = 100, envId = 6)
    # main(experiment = "M", horizon = 20000, repetitions = 100, envId = 6)
    # main(experiment = "K", horizon = 20000, repetitions = 5, envId = 6)
    # main(experiment = "T", horizon = 20000, repetitions = 100, envId = 6)
    # main(experiment = None, horizon = 18000, repetitions = 100, envId = 9)
    # main(experiment = "K", horizon = 20000, repetitions = 50, envId = 5, nb_of_instances = 10)
    # main(experiment = "T", horizon = 20000, repetitions = 5, envId = 5)
    # main(experiment = "K", horizon = 20000, repetitions = 100, envId = 6)
    # plot_dir = "C:/Users/USER/Code/SimulatuionByMe/plot/SP__K3_T20000_N100_M5_envId3"
    # mpl.rcParams['figure.dpi'] = 100
    # mpl.rcParams['figure.figsize'] = (20,10)
    # mainfig = plot_dir + "/main"
    # if mainfig is not None: mainfig = "{}__Regret".format(mainfig)
    # mpl.rcParams['figure.figsize'] = (12,8)
    # mpl.rcParams['figure.dpi'] = 200
    # plotfig = Plot()
    # fig = plotfig.plotMyRegret(savefig = mainfig, path = plot_dir)
    # main(experiment = None, horizon = 2000, repetitions = 1, envId = 5)
    # main(experiment = "K", horizon = 20000, repetitions = 50, envId = 1)
    # main(experiment = None, horizon = 20000, repetitions = 100, envId = 6)

    subfolder = "/SP__K{}_T{}_N{}_M{}_envId{}".format(3, 5000, 50, 5, 6)
    # subfolder = "/SP__M5_K3_N100_T_scaling_envId6"
    # subfolder = "/SP__K3_T20000_N100_M_scaling_envId6"
    # subfolder = "/K"
    # subfolder = "/SP__M{}_T{}_N{}_K_scaling_envId{}_nbOfins{}_ID{}".format(5, 20000, 50, 0, 2, 0)
    PLOT_DIR = "C:/Users/USER/Code/SimulatuionByMe/plot"
    plot_dir = PLOT_DIR + subfolder
    mainfig = plot_dir + "/main"
    if mainfig is not None: mainfig = "{}__Regret_with_AxSwitch".format(mainfig)
    mpl.rcParams['figure.dpi'] = 200
    mpl.rcParams['figure.figsize'] = (12,8)
    plotfig = Plot()
    fig = plotfig.plotMyRegret(savefig = mainfig, path = plot_dir)
    # fig = plotfig.plotLastRegretVersusK(savefig = mainfig, path = plot_dir)
