import torch
import tensorly as tl
from tensorly.decomposition import matrix_product_state

tl.set_backend('pytorch')
torch.manual_seed(21)

N = 2**4
vec = torch.randn(size=(N, ))
tensor = vec.reshape((2, 2, 2, 2))
# factors = matrix_product_state(tensor, rank=[1, 2, 2, 2, 1])
factors = matrix_product_state(tensor, rank=[1, 4, 4, 4, 1])
approx = tl.tt_to_tensor(factors)
print(torch.linalg.norm(approx - tensor))
