from matplotlib import pyplot as plt
import seaborn as sns
from experiments.fns import get_project_data
from experiments.fns import rename_row
from experiments.fns import label_row

# df = get_project_data(project="lr_baselines")
df = get_project_data(project="cifar_baselines", steps=[99, 199, 299, 399, -1])
df = df[df["state"] == "finished"]
df = df[df["epoch"] == 499]
df["vec"] = df.apply(rename_row, axis=1)
target_var = "train_loss_avg"

exprs = ["none (BMM0) Adam", "btt (BMM0) Adam", "fg,dfg,adg->ad (BMM0) Adam", "0.0-0.5-0.5-0.0-0.5-0.0-0.5 (BMM0) Adam"]
exprs += ["0.5-0.5-0.0-0.0-0.5-0.5-0.0 (BMM0) Adam"]
df = df[df["vec"].isin(exprs)]

sns.set(style="whitegrid", font_scale=2.0, rc={"lines.linewidth": 3.0})
sns.set_palette("Set2")
plt.figure(dpi=100, figsize=(20, 10))
sns.lineplot(x="lr", y="train_loss", data=df, style="vec", hue="width")
sns.scatterplot(x="lr", y="train_loss", data=df, style="vec", hue="width", s=200)
plt.ylabel("Train Loss")
plt.xlabel("lr")
plt.xscale("log")
plt.ylim([1.80, 2.5])
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()

df = df.loc[df.groupby(["vec", "width"])[target_var].idxmin()]
df["label"] = df.apply(label_row, axis=1)

sns.set(style="whitegrid", font_scale=2.0, rc={"lines.linewidth": 3.0})
plt.figure(dpi=75, figsize=(25, 15))
sns.set_palette("Set2")
sns.scatterplot(x="cola_flops", y=target_var, data=df, style="label", s=200)
sns.lineplot(x="cola_flops", y=target_var, data=df, style="label")
plt.ylim([1.7, 2.2])
plt.ylabel("Train Loss")
plt.xlabel('FLOPs')
plt.xscale('log')
plt.yscale('log')
plt.legend(loc='upper left', bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()
