import pandas as pd
# from experiments.fns import fit_scale_law
from experiments.fns import fit_scale_sk
from trainkit.saving import save_object

runs = pd.read_csv("./logs/mlp_scale.csv")

structs = list(runs["struct"].unique())
coeffs = {struct: "" for struct in structs}
coeffs["offset"] = 23
# coeffs["offset"] = 0

for struct in structs:
    mask = runs["struct"] == struct
    df = runs[mask]
    # theta = fit_scale_law((df["cola_flops"].values, df["test_error"].values), lr=1e-1, tol=1e-3)
    # data = (df["cola_flops"].values, df["test_error"].values)
    data = (df["cola_flops"].values, df["train_error_avg"].values)
    theta = fit_scale_sk(data, offset=coeffs["offset"])
    coeffs[struct] = theta

save_object(coeffs, filepath="./logs/coeffs_mlp.pkl")
print(coeffs)
