### do "conda activate gpt" before running this script
export WANDB_MODE=offline
export WANDB_API_KEY=1159dda0d0566b72d5cd71464a06ff6b73efb455
export WANDB__SERVICE_WAIT=300

DATA_DIR=./open_small
OUT_DIR=./
WANDB_PROJ=gpt_final

BATCH_SIZE=64
GRAD_ACCUM=8
MAX_ITERS=100_000
BLOCK_SIZE=128

# Token batch size: 512 * 128 = 65_536
# Short seq regime: d >> N / 6 ~= 20

### BTT ####
# α, β, γ, δ, ε, φ, ρ
# full rank
btt1="(0.5|0|0.5|0|0.5|0.5|0)"
btt2="(0.33|0|0.67|0|0.67|0.33|0)"
btt3="(0.25|0|0.75|0|0.75|0.25|0)"
btt5="(0.67|0|0.33|0|0.33|0.67|0)"
btt6="(0.75|0|0.25|0|0.25|0.75|0)"

# low rank
btt7="(0.67|0|0.33|0|0.67|0.33|0)"
btt8="(0.33|0|0.67|0|0.33|0.67|0)"
btt9="(0.75|0|0.25|0|0.75|0.25|0)"
btt10="(0.25|0|0.75|0|0.25|0.75|0)"

# btt rank > 1
btt11="(0.5|0|0.5|0|0.5|0.5|0.25)"
btt12="(0.5|0|0.5|0|0.5|0.5|0.33)"
btt13="(0.33|0|0.67|0|0.67|0.33|0.25)"
btt14="(0.67|0|0.33|0|0.33|0.67|0.25)"
btt15="(0.67|0|0.33|0|0.67|0.33|0.25)"
btt16="(0.33|0|0.67|0|0.33|0.67|0.25)"


# BTT
lr=3e-3
for n_layer in 6 9; do
for d_model in 256 512 1024 2048; do
for vec in ${btt1} ${btt2} ${btt3} ${btt5} ${btt6} ${btt7} ${btt8} ${btt9} ${btt10} ${btt11} ${btt12} ${btt13} ${btt14} ${btt15} ${btt16}; do
ALLOWED_GPUs="0 1 2 3 4 5 6 7"
gpu_id=$(get_free_gpu "${ALLOWED_GPUs}")
CUDA_VISIBLE_DEVICES=${gpu_id} python train_gpt.py config/train_open_small.py --block_size=${BLOCK_SIZE} --struct=simple_ein_vec_norm --expr=${vec} --layers=all_but_last --d_model=${d_model} --n_layer=${n_layer} --n_head=-1 --d_head=64 --max_iters=${MAX_ITERS} --data_dir=${DATA_DIR} --out_dir=${OUT_DIR} --batch_size=${BATCH_SIZE} --gradient_accumulation_steps=${GRAD_ACCUM} --init_lr=${lr} --wandb_project=${WANDB_PROJ}
done
done
done