### do "conda activate gpt" before running this script
export WANDB_MODE=offline
export WANDB_API_KEY=1159dda0d0566b72d5cd71464a06ff6b73efb455
export WANDB__SERVICE_WAIT=300

DATA_DIR=./open_small
OUT_DIR=./
WANDB_PROJ=gpt_final

BATCH_SIZE=64
GRAD_ACCUM=8
MAX_ITERS=100_000
BLOCK_SIZE=128

# Token batch size: 512 * 128 = 65_536
# Short seq regime: d >> N / 6 ~= 20

### BTT ####
# α, β, γ, δ, ε, φ, ρ
# full rank
btt1="(0.5|0|0.5|0|0.5|0.5|0)"


# BTT
lr=3e-3
for n_layer in 3 9; do
for d_model in 256 512 1024 2048; do
for vec in ${btt1}; do
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 torchrun --nproc_per_node=8 --master_port=$(shuf -i 49152-65535 -n 1) \
train_gpt.py config/train_open_small.py --block_size=${BLOCK_SIZE} --struct=simple_ein_vec_norm --expr=${vec} --layers=all_but_last --d_model=${d_model} --n_layer=${n_layer} --n_head=-1 --d_head=64 --max_iters=${MAX_ITERS} --data_dir=${DATA_DIR} --out_dir=${OUT_DIR} --batch_size=${BATCH_SIZE} --gradient_accumulation_steps=${GRAD_ACCUM} --init_lr=${lr} --wandb_project=${WANDB_PROJ} --use_head_btt=True --head_btt_case_qkv="(n|d|n|d)" --head_btt_case_proj="(n|d|n|d)"
done
done
done