from matplotlib import pyplot as plt
import seaborn as sns
import numpy as np

Ds = [50, 100, 500, 1000]
frob = np.zeros(len(Ds))
for jdx, D in enumerate(Ds):
    D = 10
    A = np.random.normal(size=(D, D))
    B = np.random.normal(size=(D, 1))

    C = A @ B
    frob[jdx] = np.linalg.norm(C, ord="fro")
    # frob[jdx] = np.linalg.norm(A, ord="fro")

sns.set(style="whitegrid", font_scale=2.0, rc={"lines.linewidth": 3.0})
sns.set_palette("Set2")
plt.figure(dpi=100, figsize=(20, 10))
plt.plot(Ds, frob, label="case")
# plt.plot(Ds, Ds, label="y=x")
plt.plot(Ds, np.sqrt(Ds), label="y=sqrt(x)")
plt.ylabel("Norm")
plt.xlabel('Size')
plt.legend(loc='upper left', bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()
