import os
os.environ["KMP_DUPLICATE_LIB_OK"]="TRUE"
import os
import os.path as p
import numpy as np
import torch
from scipy.sparse import csr_matrix
from sklearn.neighbors import KDTree

#
# def similarity_matrix(X, k=10, sigma=1.0):
#     dm = euclidean_distances(X, X)
#     row = np.arange(0, X.shape[0])
#     dm[row, row] = np.inf
#     idx = np.argpartition(dm, k, axis=1)[:, :k]
#     dist_knn = np.take_along_axis(dm, idx, axis=1)
#     sim_knn = np.exp(-dist_knn ** 2 / (2 * sigma ** 2))
#     sim_m = np.zeros_like(dm)
#     sim_m[row[:, np.newaxis], idx] = sim_knn
#     sim_m = (sim_m + sim_m.T) / 2  # ensure symmetry
#     return torch.from_numpy(sim_m).cuda()


def get_similarity_matrix(train_datai, K = 10):
    k = min(K, train_datai.shape[0] - 1)
# view_num = len(train_datai)
    ins_num = train_datai.shape[0]
    trans = csr_matrix((ins_num, ins_num), dtype=np.float32)
 
    train_data = (train_datai - np.mean(train_datai, axis=0)) / (np.std(train_datai, axis=0) +  1e-8)
    train_data = np.where(np.isnan(train_data), np.full_like(train_data, 1), train_data)
    train_data = np.where(np.isinf(train_data), np.full_like(train_data, 1), train_data)
    fea_num = train_data.shape[1]
    kdtree = KDTree(train_data)
    dist, neighbor = kdtree.query(train_data, k=k+1)
    neighbor = neighbor[:, 1:]
    dist = dist[:, 1:]
    rows = np.tile(np.arange(ins_num)[:, np.newaxis], (1, k))
    datas = np.zeros((ins_num, k), dtype=np.float32)
    for i in range(ins_num):
        neighborIns = train_data[neighbor[i], :]
        w = np.exp(-np.sum((neighborIns - train_data[i, :])**2, axis=1))
        datas[i, :] = w
    trans += csr_matrix((datas.flatten(), (rows.flatten(), neighbor.flatten())),
                        shape=(ins_num, ins_num))
    S = trans.toarray()
    S = (S + S.T) / 2
    return torch.from_numpy(S).cuda()



# a = np.random.random((15,6))
# S = get_similarity_matrix(a)
# print("a: ", a)
# print("S: ", S)
# print("S[0][4]: ", S[0][4])
