# Always Survivor DTR: Optimal Dynamic Treatment Regimes under Truncation by Death

This repository contains code and resources for investigating optimal dynamic treatment regimes (DTRs) in the presence of truncation by death.

## Contents

* **`environment.yml`**: Use this file to create the conda environment required for reproducibility.
* **`Simulation *.ipynb`**: These notebooks contain the code for our simulated experiments. These notebooks allow you to reproduce our simulation studies and explore the behavior of the proposed methods under various scenarios.
* **`MIMIC3 preprocess.ipynb`**: This notebook provides the code used to preprocess the MIMIC-III critical care database into a format suitable for our analysis. It handles data cleaning and preparation for subsequent modeling.
* **`MIMIC3 analysis.ipynb`**: This notebook contains the analysis conducted on the preprocessed MIMIC-III data. It implements our proposed approach and compares its performance against standard methodology.

## External Resources

* **MIMIC-III Critical Care Database**: You can access MIMIC-III through [PhysioNet](https://physionet.org/content/mimiciii/)
* **AI Clinician Preprocessing Tools**: Use the [AI Clinician](https://github.com/matthieukomorowski/AI_Clinician) tool for initial processing of the raw MIMIC-III data before applying our preprocessing steps.

## Citation

We encourage you to cite our work if you use the code or findings from this repository. 

```latex
The citation information will be updated here upon publication.
```

