from typing import Sequence

from ..types import IntBinarySample, IntBinary
from .perturbation import RandomPerturbation


class NullPerturbation(RandomPerturbation[IntBinarySample, IntBinary]):
    """A perturbation that returns the input unchanged"""

    def __call__(self, input: IntBinarySample) -> IntBinary:
        super().__call__(input)
        binaries, metadata = input
        return binaries

    def certified_radius(
        self,
        input: IntBinarySample,
        pred: int,
        counts: Sequence[int],
        alpha: float = 0.05,
        **kwargs,
    ) -> float:
        return 0
