from .metadata import Metadata

import torch
from typing import Tuple, Union, Optional

ByteBinary = Union[bytes, bytearray, torch.ByteTensor]
IntBinary = torch.IntTensor
Binary = Union[ByteBinary, IntBinary]

ByteBinarySample = Tuple[ByteBinary, Optional[Metadata]]
IntBinarySample = Tuple[IntBinary, Optional[Metadata]]
BinarySample = Tuple[Binary, Optional[Metadata]]

EmbedBinary = torch.FloatTensor
EmbedBinarySample = Tuple[EmbedBinary, Optional[Metadata]]
