from typing import Union, Literal
from rich.progress import track, open as rich_open
from pytorch_lightning.utilities.rank_zero import rank_zero_only


def rank_zero_rich_track(
    iterable, desc: str = None, total: int = None, disable: bool = False
):
    """
    Wrapper for rich.progress.track that only runs on rank 0
    """
    rank = rank_zero_only.rank
    if rank == 0:
        return track(iterable, description=desc, total=total, disable=disable)
    return iterable


def rank_zero_rich_open(
    file: Union[str, bytes],
    mode: Union[Literal["rt"], Literal["r"]],
    description: str = "Reading...",
):
    """
    Wrapper for rich.progress.open that only runs on rank 0
    """
    rank = rank_zero_only.rank
    if rank == 0:
        return rich_open(file, mode, description=description)
    return open(file, mode)
