"""
Entrypoint for launching train jobs.
The first argument must be a yaml training configuration file path.
The additional arguments support commandline override.
"""

from sys import argv
import torch
from lightning_utilities.core.imports import RequirementCache

from common.config import create_object, load_config
from common.entrypoint import Entrypoint

# import torch._dynamo

# torch._dynamo.config.suppress_errors = True

# Disable lightning wandb requirement check.
old_check_available = RequirementCache._check_available


def new_check_available(self):
    if self.requirement.startswith("wandb"):
        self.available = True
        return
    old_check_available(self)


RequirementCache._check_available = new_check_available


# Load config.
config = load_config(argv[1], argv[2:])

# Load trainer.
entrypoint = create_object(config)
assert isinstance(entrypoint, Entrypoint)

# Start trainer.
entrypoint.entrypoint()
