# From https://github.com/open-mmlab/mmpose/

COCO_SKELETON_INFO = {
    0: dict(link=("left_ankle", "left_knee"), id=0, color=[0, 255, 0]),
    1: dict(link=("left_knee", "left_hip"), id=1, color=[0, 255, 0]),
    2: dict(link=("right_ankle", "right_knee"), id=2, color=[255, 128, 0]),
    3: dict(link=("right_knee", "right_hip"), id=3, color=[255, 128, 0]),
    4: dict(link=("left_hip", "right_hip"), id=4, color=[51, 153, 255]),
    5: dict(link=("left_shoulder", "left_hip"), id=5, color=[51, 153, 255]),
    6: dict(link=("right_shoulder", "right_hip"), id=6, color=[51, 153, 255]),
    7: dict(link=("left_shoulder", "right_shoulder"), id=7, color=[51, 153, 255]),
    8: dict(link=("left_shoulder", "left_elbow"), id=8, color=[0, 255, 0]),
    9: dict(link=("right_shoulder", "right_elbow"), id=9, color=[255, 128, 0]),
    10: dict(link=("left_elbow", "left_wrist"), id=10, color=[0, 255, 0]),
    11: dict(link=("right_elbow", "right_wrist"), id=11, color=[255, 128, 0]),
    12: dict(link=("left_eye", "right_eye"), id=12, color=[51, 153, 255]),
    13: dict(link=("nose", "left_eye"), id=13, color=[51, 153, 255]),
    14: dict(link=("nose", "right_eye"), id=14, color=[51, 153, 255]),
    15: dict(link=("left_eye", "left_ear"), id=15, color=[51, 153, 255]),
    16: dict(link=("right_eye", "right_ear"), id=16, color=[51, 153, 255]),
    17: dict(link=("left_ear", "left_shoulder"), id=17, color=[51, 153, 255]),
    18: dict(link=("right_ear", "right_shoulder"), id=18, color=[51, 153, 255]),
}

COCO_JOINT_MAP = {
    "nose": 0,
    "left_eye": 1,
    "right_eye": 2,
    "left_ear": 3,
    "right_ear": 4,
    "left_shoulder": 5,
    "right_shoulder": 6,
    "left_elbow": 7,
    "right_elbow": 8,
    "left_wrist": 9,
    "right_wrist": 10,
    "left_hip": 11,
    "right_hip": 12,
    "left_knee": 13,
    "right_knee": 14,
    "left_ankle": 15,
    "right_ankle": 16,
}

cocoLimbSeq = [
    [2, 3],
    [2, 6],
    [3, 4],
    [4, 5],
    [6, 7],
    [7, 8],
    [2, 9],
    [9, 10],
    [10, 11],
    [2, 12],
    [12, 13],
    [13, 14],
    [2, 1],
    [1, 15],
    [15, 17],
    [1, 16],
    [16, 18],
    [3, 17],
    [6, 18],
]
