// tvm target: c -keys=partial_conv,arm_cpu,cpu -mcpu=cortex-m4+nodsp -model=nrf52840
#define TVM_EXPORTS
#include "tvm/runtime/c_runtime_api.h"
#include "tvm/runtime/c_backend_api.h"
#include <math.h>
#include <stdbool.h>
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_1_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_1(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_2_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_10(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_11_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_11(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_12_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_12(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_13_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_13(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_14_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_14(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_15_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_15(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_16_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_16(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_17_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_17(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_18_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_18(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_19_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_19(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_20_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_2(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_3_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_20(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_21_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_21(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_22_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_22(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_23_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_23(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_24_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_24(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_25_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_25(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_26_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_26(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_27_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_27(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_28_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_28(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_29_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_29(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_30_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_3(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_4_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_30(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_31_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_31(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_32_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_32(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_33_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_33(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_34_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_34(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_35_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_35(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_36_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_36(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_37_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_37(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_38_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_38(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_39_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_39(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_40_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_4(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_5_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_40(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_41_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_41(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_42_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_42(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_43_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_43(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_44_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_44(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_45_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_5(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_6_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_6(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_7_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_7(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_8_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_8(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_9_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_9(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_10_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default___tvm_main__(int8_t* data_buffer_var, int8_t* conv2d_1_buffer_var, int8_t* weight_depth_wise_1_buffer_var, int8_t* conv2d_2_buffer_var, int8_t* weight_1x1_conv2d_18_buffer_var, int8_t* weight_depth_wise_18_buffer_var, int8_t* weight_1x1_conv2d_linear_18_buffer_var, int8_t* weight_1x1_conv2d_19_buffer_var, int8_t* weight_depth_wise_19_buffer_var, int8_t* weight_1x1_conv2d_linear_19_buffer_var, int8_t* weight_1x1_conv2d_20_buffer_var, int8_t* weight_depth_wise_20_buffer_var, int8_t* weight_1x1_conv2d_linear_20_buffer_var, int8_t* weight_1x1_conv2d_21_buffer_var, int8_t* weight_depth_wise_21_buffer_var, int8_t* weight_1x1_conv2d_linear_21_buffer_var, int8_t* weight_1x1_conv2d_22_buffer_var, int8_t* weight_depth_wise_22_buffer_var, int8_t* weight_1x1_conv2d_linear_22_buffer_var, int8_t* weight_1x1_conv2d_23_buffer_var, int8_t* weight_depth_wise_23_buffer_var, int8_t* weight_1x1_conv2d_linear_23_buffer_var, int8_t* weight_1x1_conv2d_24_buffer_var, int8_t* weight_depth_wise_24_buffer_var, int8_t* weight_1x1_conv2d_linear_24_buffer_var, int8_t* weight_1x1_conv2d_25_buffer_var, int8_t* weight_depth_wise_25_buffer_var, int8_t* weight_1x1_conv2d_linear_25_buffer_var, int8_t* weight_1x1_conv2d_26_buffer_var, int8_t* weight_depth_wise_26_buffer_var, int8_t* weight_1x1_conv2d_linear_26_buffer_var, int8_t* weight_1x1_conv2d_27_buffer_var, int8_t* weight_depth_wise_27_buffer_var, int8_t* weight_1x1_conv2d_linear_27_buffer_var, int8_t* weight_1x1_conv2d_28_buffer_var, int8_t* weight_depth_wise_28_buffer_var, int8_t* weight_1x1_conv2d_linear_28_buffer_var, int8_t* weight_1x1_conv2d_29_buffer_var, int8_t* weight_depth_wise_29_buffer_var, int8_t* weight_1x1_conv2d_linear_29_buffer_var, int8_t* weight_1x1_conv2d_30_buffer_var, int8_t* weight_depth_wise_30_buffer_var, int8_t* weight_1x1_conv2d_linear_30_buffer_var, int8_t* weight_1x1_conv2d_31_buffer_var, int8_t* weight_depth_wise_31_buffer_var, int8_t* weight_1x1_conv2d_linear_31_buffer_var, int8_t* output_buffer_var, uint8_t* global_workspace_0_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_1_var) {
  void* pad_temp_let = (&(global_workspace_1_var[0]));
  for (int32_t i1 = 0; i1 < 3; ++i1) {
    for (int32_t i2 = 0; i2 < 81; ++i2) {
      for (int32_t i3 = 0; i3 < 81; ++i3) {
        int8_t condval;
        if (((1 <= i2) && (1 <= i3))) {
          condval = p0[((((i1 * 6400) + (i2 * 80)) + i3) - 81)];
        } else {
          condval = (int8_t)0;
        }
        ((int8_t*)pad_temp_let)[(((i1 * 6561) + (i2 * 81)) + i3)] = condval;
      }
    }
  }
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 40; ++yy) {
      for (int32_t xx = 0; xx < 40; ++xx) {
        conv2d_nchw[(((ff * 1600) + (yy * 40)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 3; ++rc) {
          for (int32_t ry = 0; ry < 3; ++ry) {
            for (int32_t rx = 0; rx < 3; ++rx) {
              int32_t cse_var_1 = (((ff * 1600) + (yy * 40)) + xx);
              conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (((int8_t*)pad_temp_let)[(((((rc * 6561) + (yy * 162)) + (ry * 81)) + (xx * 2)) + rx)] * p1[((((ff * 27) + (rc * 9)) + (ry * 3)) + rx)]));
            }
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_1(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_2_var) {
  for (int32_t c = 0; c < 16; ++c) {
    for (int32_t i = 0; i < 40; ++i) {
      for (int32_t j = 0; j < 40; ++j) {
        DepthwiseConv2d[(((c * 1600) + (i * 40)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 1600);
            int32_t cse_var_1 = ((cse_var_2 + (i * 40)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 40) * 40)) + ((j + dj) % 40))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_10(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_11_var) {
  for (int32_t c = 0; c < 48; ++c) {
    for (int32_t i = 0; i < 20; ++i) {
      for (int32_t j = 0; j < 20; ++j) {
        DepthwiseConv2d[(((c * 400) + (i * 20)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 400);
            int32_t cse_var_1 = ((cse_var_2 + (i * 20)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 20) * 20)) + ((j + dj) % 20))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_11(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_12_var) {
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 20; ++yy) {
      for (int32_t xx = 0; xx < 20; ++xx) {
        conv2d_nchw[(((ff * 400) + (yy * 20)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 20);
          int32_t cse_var_1 = (((ff * 400) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 400) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_12(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_13_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 20; ++yy) {
      for (int32_t xx = 0; xx < 20; ++xx) {
        conv2d_nchw[(((ff * 400) + (yy * 20)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 20);
          int32_t cse_var_1 = (((ff * 400) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 400) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_13(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_14_var) {
  for (int32_t c = 0; c < 48; ++c) {
    for (int32_t i = 0; i < 10; ++i) {
      for (int32_t j = 0; j < 10; ++j) {
        DepthwiseConv2d[(((c * 100) + (i * 10)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_1 = (((c * 100) + (i * 10)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 400) + ((((i * 2) + di) % 20) * 20)) + (((j * 2) + dj) % 20))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_14(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_15_var) {
  for (int32_t ff = 0; ff < 24; ++ff) {
    for (int32_t yy = 0; yy < 10; ++yy) {
      for (int32_t xx = 0; xx < 10; ++xx) {
        conv2d_nchw[(((ff * 100) + (yy * 10)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 10);
          int32_t cse_var_1 = (((ff * 100) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 100) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_15(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_16_var) {
  for (int32_t ff = 0; ff < 144; ++ff) {
    for (int32_t yy = 0; yy < 10; ++yy) {
      for (int32_t xx = 0; xx < 10; ++xx) {
        conv2d_nchw[(((ff * 100) + (yy * 10)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 24; ++rc) {
          int32_t cse_var_2 = (yy * 10);
          int32_t cse_var_1 = (((ff * 100) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 100) + cse_var_2) + xx)] * p1[((ff * 24) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_16(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_17_var) {
  for (int32_t c = 0; c < 144; ++c) {
    for (int32_t i = 0; i < 10; ++i) {
      for (int32_t j = 0; j < 10; ++j) {
        DepthwiseConv2d[(((c * 100) + (i * 10)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 100);
            int32_t cse_var_1 = ((cse_var_2 + (i * 10)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 10) * 10)) + ((j + dj) % 10))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_17(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_18_var) {
  for (int32_t ff = 0; ff < 24; ++ff) {
    for (int32_t yy = 0; yy < 10; ++yy) {
      for (int32_t xx = 0; xx < 10; ++xx) {
        conv2d_nchw[(((ff * 100) + (yy * 10)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 144; ++rc) {
          int32_t cse_var_2 = (yy * 10);
          int32_t cse_var_1 = (((ff * 100) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 100) + cse_var_2) + xx)] * p1[((ff * 144) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_18(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_19_var) {
  for (int32_t ff = 0; ff < 120; ++ff) {
    for (int32_t yy = 0; yy < 10; ++yy) {
      for (int32_t xx = 0; xx < 10; ++xx) {
        conv2d_nchw[(((ff * 100) + (yy * 10)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 24; ++rc) {
          int32_t cse_var_2 = (yy * 10);
          int32_t cse_var_1 = (((ff * 100) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 100) + cse_var_2) + xx)] * p1[((ff * 24) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_19(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_20_var) {
  for (int32_t c = 0; c < 120; ++c) {
    for (int32_t i = 0; i < 10; ++i) {
      for (int32_t j = 0; j < 10; ++j) {
        DepthwiseConv2d[(((c * 100) + (i * 10)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 5; ++di) {
          for (int32_t dj = 0; dj < 5; ++dj) {
            int32_t cse_var_2 = (c * 100);
            int32_t cse_var_1 = ((cse_var_2 + (i * 10)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 10) * 10)) + ((j + dj) % 10))] * p1[(((c * 25) + (di * 5)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_2(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_3_var) {
  for (int32_t ff = 0; ff < 8; ++ff) {
    for (int32_t yy = 0; yy < 40; ++yy) {
      for (int32_t xx = 0; xx < 40; ++xx) {
        conv2d_nchw[(((ff * 1600) + (yy * 40)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 40);
          int32_t cse_var_1 = (((ff * 1600) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1600) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_20(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_21_var) {
  for (int32_t ff = 0; ff < 24; ++ff) {
    for (int32_t yy = 0; yy < 10; ++yy) {
      for (int32_t xx = 0; xx < 10; ++xx) {
        conv2d_nchw[(((ff * 100) + (yy * 10)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 120; ++rc) {
          int32_t cse_var_2 = (yy * 10);
          int32_t cse_var_1 = (((ff * 100) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 100) + cse_var_2) + xx)] * p1[((ff * 120) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_21(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_22_var) {
  for (int32_t ff = 0; ff < 144; ++ff) {
    for (int32_t yy = 0; yy < 10; ++yy) {
      for (int32_t xx = 0; xx < 10; ++xx) {
        conv2d_nchw[(((ff * 100) + (yy * 10)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 24; ++rc) {
          int32_t cse_var_2 = (yy * 10);
          int32_t cse_var_1 = (((ff * 100) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 100) + cse_var_2) + xx)] * p1[((ff * 24) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_22(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_23_var) {
  for (int32_t c = 0; c < 144; ++c) {
    for (int32_t i = 0; i < 5; ++i) {
      for (int32_t j = 0; j < 5; ++j) {
        DepthwiseConv2d[(((c * 25) + (i * 5)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_1 = (((c * 25) + (i * 5)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 100) + ((((i * 2) + di) % 10) * 10)) + (((j * 2) + dj) % 10))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_23(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_24_var) {
  for (int32_t ff = 0; ff < 40; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 144; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 144) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_24(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_25_var) {
  for (int32_t ff = 0; ff < 240; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 40; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 40) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_25(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_26_var) {
  for (int32_t c = 0; c < 240; ++c) {
    for (int32_t i = 0; i < 5; ++i) {
      for (int32_t j = 0; j < 5; ++j) {
        DepthwiseConv2d[(((c * 25) + (i * 5)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_2 = (c * 25);
            int32_t cse_var_1 = ((cse_var_2 + (i * 5)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 5) * 5)) + ((j + dj) % 5))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_26(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_27_var) {
  for (int32_t ff = 0; ff < 40; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 240; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 240) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_27(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_28_var) {
  for (int32_t ff = 0; ff < 240; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 40; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 40) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_28(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_29_var) {
  for (int32_t c = 0; c < 240; ++c) {
    for (int32_t i = 0; i < 5; ++i) {
      for (int32_t j = 0; j < 5; ++j) {
        DepthwiseConv2d[(((c * 25) + (i * 5)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 25);
            int32_t cse_var_1 = ((cse_var_2 + (i * 5)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 5) * 5)) + ((j + dj) % 5))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_29(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_30_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 240; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 240) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_3(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_4_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 40; ++yy) {
      for (int32_t xx = 0; xx < 40; ++xx) {
        conv2d_nchw[(((ff * 1600) + (yy * 40)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 8; ++rc) {
          int32_t cse_var_2 = (yy * 40);
          int32_t cse_var_1 = (((ff * 1600) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1600) + cse_var_2) + xx)] * p1[((ff * 8) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_30(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_31_var) {
  for (int32_t ff = 0; ff < 192; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_31(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_32_var) {
  for (int32_t c = 0; c < 192; ++c) {
    for (int32_t i = 0; i < 5; ++i) {
      for (int32_t j = 0; j < 5; ++j) {
        DepthwiseConv2d[(((c * 25) + (i * 5)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 25);
            int32_t cse_var_1 = ((cse_var_2 + (i * 5)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 5) * 5)) + ((j + dj) % 5))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_32(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_33_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 192; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 192) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_33(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_34_var) {
  for (int32_t ff = 0; ff < 240; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_34(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_35_var) {
  for (int32_t c = 0; c < 240; ++c) {
    for (int32_t i = 0; i < 3; ++i) {
      for (int32_t j = 0; j < 3; ++j) {
        DepthwiseConv2d[(((c * 9) + (i * 3)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 5; ++di) {
          for (int32_t dj = 0; dj < 5; ++dj) {
            int32_t cse_var_2 = (c * 25);
            int32_t cse_var_1 = (((c * 9) + (i * 3)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + ((((i * 2) + di) % 5) * 5)) + (((j * 2) + dj) % 5))] * p1[((cse_var_2 + (di * 5)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_35(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_36_var) {
  for (int32_t ff = 0; ff < 96; ++ff) {
    for (int32_t yy = 0; yy < 3; ++yy) {
      for (int32_t xx = 0; xx < 3; ++xx) {
        conv2d_nchw[(((ff * 9) + (yy * 3)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 240; ++rc) {
          int32_t cse_var_2 = (yy * 3);
          int32_t cse_var_1 = (((ff * 9) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 9) + cse_var_2) + xx)] * p1[((ff * 240) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_36(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_37_var) {
  for (int32_t ff = 0; ff < 480; ++ff) {
    for (int32_t yy = 0; yy < 3; ++yy) {
      for (int32_t xx = 0; xx < 3; ++xx) {
        conv2d_nchw[(((ff * 9) + (yy * 3)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 96; ++rc) {
          int32_t cse_var_2 = (yy * 3);
          int32_t cse_var_1 = (((ff * 9) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 9) + cse_var_2) + xx)] * p1[((ff * 96) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_37(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_38_var) {
  for (int32_t c = 0; c < 480; ++c) {
    for (int32_t i = 0; i < 3; ++i) {
      for (int32_t j = 0; j < 3; ++j) {
        DepthwiseConv2d[(((c * 9) + (i * 3)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 9);
            int32_t cse_var_1 = ((cse_var_2 + (i * 3)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 3) * 3)) + ((j + dj) % 3))] * p1[((cse_var_2 + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_38(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_39_var) {
  for (int32_t ff = 0; ff < 96; ++ff) {
    for (int32_t yy = 0; yy < 3; ++yy) {
      for (int32_t xx = 0; xx < 3; ++xx) {
        conv2d_nchw[(((ff * 9) + (yy * 3)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 480; ++rc) {
          int32_t cse_var_2 = (yy * 3);
          int32_t cse_var_1 = (((ff * 9) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 9) + cse_var_2) + xx)] * p1[((ff * 480) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_39(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_40_var) {
  for (int32_t ff = 0; ff < 384; ++ff) {
    for (int32_t yy = 0; yy < 3; ++yy) {
      for (int32_t xx = 0; xx < 3; ++xx) {
        conv2d_nchw[(((ff * 9) + (yy * 3)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 96; ++rc) {
          int32_t cse_var_2 = (yy * 3);
          int32_t cse_var_1 = (((ff * 9) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 9) + cse_var_2) + xx)] * p1[((ff * 96) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_4(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_5_var) {
  for (int32_t c = 0; c < 48; ++c) {
    for (int32_t i = 0; i < 20; ++i) {
      for (int32_t j = 0; j < 20; ++j) {
        DepthwiseConv2d[(((c * 400) + (i * 20)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_1 = (((c * 400) + (i * 20)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 1600) + ((((i * 2) + di) % 40) * 40)) + (((j * 2) + dj) % 40))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_40(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_41_var) {
  for (int32_t c = 0; c < 384; ++c) {
    for (int32_t i = 0; i < 3; ++i) {
      for (int32_t j = 0; j < 3; ++j) {
        DepthwiseConv2d[(((c * 9) + (i * 3)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 9);
            int32_t cse_var_1 = ((cse_var_2 + (i * 3)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 3) * 3)) + ((j + dj) % 3))] * p1[((cse_var_2 + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_41(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_42_var) {
  for (int32_t ff = 0; ff < 96; ++ff) {
    for (int32_t yy = 0; yy < 3; ++yy) {
      for (int32_t xx = 0; xx < 3; ++xx) {
        conv2d_nchw[(((ff * 9) + (yy * 3)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 384; ++rc) {
          int32_t cse_var_2 = (yy * 3);
          int32_t cse_var_1 = (((ff * 9) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 9) + cse_var_2) + xx)] * p1[((ff * 384) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_42(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_43_var) {
  for (int32_t ff = 0; ff < 288; ++ff) {
    for (int32_t yy = 0; yy < 3; ++yy) {
      for (int32_t xx = 0; xx < 3; ++xx) {
        conv2d_nchw[(((ff * 9) + (yy * 3)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 96; ++rc) {
          int32_t cse_var_2 = (yy * 3);
          int32_t cse_var_1 = (((ff * 9) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 9) + cse_var_2) + xx)] * p1[((ff * 96) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_43(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_44_var) {
  for (int32_t c = 0; c < 288; ++c) {
    for (int32_t i = 0; i < 3; ++i) {
      for (int32_t j = 0; j < 3; ++j) {
        DepthwiseConv2d[(((c * 9) + (i * 3)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_2 = (c * 9);
            int32_t cse_var_1 = ((cse_var_2 + (i * 3)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 3) * 3)) + ((j + dj) % 3))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_44(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_45_var) {
  for (int32_t ff = 0; ff < 160; ++ff) {
    for (int32_t yy = 0; yy < 3; ++yy) {
      for (int32_t xx = 0; xx < 3; ++xx) {
        conv2d_nchw[(((ff * 9) + (yy * 3)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 288; ++rc) {
          int32_t cse_var_2 = (yy * 3);
          int32_t cse_var_1 = (((ff * 9) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 9) + cse_var_2) + xx)] * p1[((ff * 288) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_5(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_6_var) {
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 20; ++yy) {
      for (int32_t xx = 0; xx < 20; ++xx) {
        conv2d_nchw[(((ff * 400) + (yy * 20)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 20);
          int32_t cse_var_1 = (((ff * 400) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 400) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_6(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_7_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 20; ++yy) {
      for (int32_t xx = 0; xx < 20; ++xx) {
        conv2d_nchw[(((ff * 400) + (yy * 20)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 20);
          int32_t cse_var_1 = (((ff * 400) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 400) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_7(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_8_var) {
  for (int32_t c = 0; c < 48; ++c) {
    for (int32_t i = 0; i < 20; ++i) {
      for (int32_t j = 0; j < 20; ++j) {
        DepthwiseConv2d[(((c * 400) + (i * 20)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 400);
            int32_t cse_var_1 = ((cse_var_2 + (i * 20)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 20) * 20)) + ((j + dj) % 20))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_8(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_9_var) {
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 20; ++yy) {
      for (int32_t xx = 0; xx < 20; ++xx) {
        conv2d_nchw[(((ff * 400) + (yy * 20)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 20);
          int32_t cse_var_1 = (((ff * 400) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 400) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_9(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_10_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 20; ++yy) {
      for (int32_t xx = 0; xx < 20; ++xx) {
        conv2d_nchw[(((ff * 400) + (yy * 20)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 20);
          int32_t cse_var_1 = (((ff * 400) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 400) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default___tvm_main__(int8_t* data_buffer_var, int8_t* conv2d_1_buffer_var, int8_t* weight_depth_wise_1_buffer_var, int8_t* conv2d_2_buffer_var, int8_t* weight_1x1_conv2d_18_buffer_var, int8_t* weight_depth_wise_18_buffer_var, int8_t* weight_1x1_conv2d_linear_18_buffer_var, int8_t* weight_1x1_conv2d_19_buffer_var, int8_t* weight_depth_wise_19_buffer_var, int8_t* weight_1x1_conv2d_linear_19_buffer_var, int8_t* weight_1x1_conv2d_20_buffer_var, int8_t* weight_depth_wise_20_buffer_var, int8_t* weight_1x1_conv2d_linear_20_buffer_var, int8_t* weight_1x1_conv2d_21_buffer_var, int8_t* weight_depth_wise_21_buffer_var, int8_t* weight_1x1_conv2d_linear_21_buffer_var, int8_t* weight_1x1_conv2d_22_buffer_var, int8_t* weight_depth_wise_22_buffer_var, int8_t* weight_1x1_conv2d_linear_22_buffer_var, int8_t* weight_1x1_conv2d_23_buffer_var, int8_t* weight_depth_wise_23_buffer_var, int8_t* weight_1x1_conv2d_linear_23_buffer_var, int8_t* weight_1x1_conv2d_24_buffer_var, int8_t* weight_depth_wise_24_buffer_var, int8_t* weight_1x1_conv2d_linear_24_buffer_var, int8_t* weight_1x1_conv2d_25_buffer_var, int8_t* weight_depth_wise_25_buffer_var, int8_t* weight_1x1_conv2d_linear_25_buffer_var, int8_t* weight_1x1_conv2d_26_buffer_var, int8_t* weight_depth_wise_26_buffer_var, int8_t* weight_1x1_conv2d_linear_26_buffer_var, int8_t* weight_1x1_conv2d_27_buffer_var, int8_t* weight_depth_wise_27_buffer_var, int8_t* weight_1x1_conv2d_linear_27_buffer_var, int8_t* weight_1x1_conv2d_28_buffer_var, int8_t* weight_depth_wise_28_buffer_var, int8_t* weight_1x1_conv2d_linear_28_buffer_var, int8_t* weight_1x1_conv2d_29_buffer_var, int8_t* weight_depth_wise_29_buffer_var, int8_t* weight_1x1_conv2d_linear_29_buffer_var, int8_t* weight_1x1_conv2d_30_buffer_var, int8_t* weight_depth_wise_30_buffer_var, int8_t* weight_1x1_conv2d_linear_30_buffer_var, int8_t* weight_1x1_conv2d_31_buffer_var, int8_t* weight_depth_wise_31_buffer_var, int8_t* weight_1x1_conv2d_linear_31_buffer_var, int8_t* output_buffer_var, uint8_t* global_workspace_0_var) {
  void* sid_79_let = (&(global_workspace_0_var[0]));
  void* sid_84_let = (&(global_workspace_0_var[6912]));
  void* sid_67_let = (&(global_workspace_0_var[0]));
  void* sid_60_let = (&(global_workspace_0_var[0]));
  void* sid_70_let = (&(global_workspace_0_var[6000]));
  void* sid_71_let = (&(global_workspace_0_var[0]));
  void* sid_64_let = (&(global_workspace_0_var[12000]));
  void* sid_74_let = (&(global_workspace_0_var[0]));
  void* sid_73_let = (&(global_workspace_0_var[6000]));
  void* sid_66_let = (&(global_workspace_0_var[14400]));
  void* sid_58_let = (&(global_workspace_0_var[0]));
  void* sid_62_let = (&(global_workspace_0_var[0]));
  void* sid_57_let = (&(global_workspace_0_var[19200]));
  void* sid_56_let = (&(global_workspace_0_var[0]));
  void* sid_81_let = (&(global_workspace_0_var[0]));
  void* sid_82_let = (&(global_workspace_0_var[4320]));
  void* sid_52_let = (&(global_workspace_0_var[19200]));
  void* sid_77_let = (&(global_workspace_0_var[0]));
  void* sid_80_let = (&(global_workspace_0_var[6000]));
  void* sid_78_let = (&(global_workspace_0_var[6000]));
  void* sid_51_let = (&(global_workspace_0_var[0]));
  void* sid_76_let = (&(global_workspace_0_var[4800]));
  void* sid_53_let = (&(global_workspace_0_var[0]));
  void* sid_72_let = (&(global_workspace_0_var[12000]));
  void* sid_65_let = (&(global_workspace_0_var[0]));
  void* sid_54_let = (&(global_workspace_0_var[38400]));
  void* sid_68_let = (&(global_workspace_0_var[14400]));
  void* sid_83_let = (&(global_workspace_0_var[0]));
  void* sid_55_let = (&(global_workspace_0_var[19200]));
  void* sid_61_let = (&(global_workspace_0_var[14400]));
  void* sid_63_let = (&(global_workspace_0_var[24000]));
  void* sid_69_let = (&(global_workspace_0_var[0]));
  void* sid_49_let = (&(global_workspace_0_var[0]));
  void* sid_59_let = (&(global_workspace_0_var[19200]));
  void* sid_46_let = (&(global_workspace_0_var[25600]));
  void* sid_75_let = (&(global_workspace_0_var[9600]));
  void* sid_47_let = (&(global_workspace_0_var[0]));
  void* sid_85_let = (&(global_workspace_0_var[3456]));
  void* sid_48_let = (&(global_workspace_0_var[76800]));
  void* sid_50_let = (&(global_workspace_0_var[76800]));
  void* sid_86_let = (&(global_workspace_0_var[0]));
  void* sid_87_let = (&(global_workspace_0_var[3456]));
  void* sid_88_let = (&(global_workspace_0_var[0]));
  void* sid_89_let = (&(global_workspace_0_var[2592]));
  if (tvmgen_default_fused_nn_conv2d(data_buffer_var, conv2d_1_buffer_var, sid_46_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_1(sid_46_let, weight_depth_wise_1_buffer_var, sid_47_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_2(sid_47_let, conv2d_2_buffer_var, sid_48_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_3(sid_48_let, weight_1x1_conv2d_18_buffer_var, sid_49_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_4(sid_49_let, weight_depth_wise_18_buffer_var, sid_50_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_5(sid_50_let, weight_1x1_conv2d_linear_18_buffer_var, sid_51_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_6(sid_51_let, weight_1x1_conv2d_19_buffer_var, sid_52_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_7(sid_52_let, weight_depth_wise_19_buffer_var, sid_53_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_8(sid_53_let, weight_1x1_conv2d_linear_19_buffer_var, sid_54_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_9(sid_54_let, weight_1x1_conv2d_20_buffer_var, sid_55_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_10(sid_55_let, weight_depth_wise_20_buffer_var, sid_56_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_11(sid_56_let, weight_1x1_conv2d_linear_20_buffer_var, sid_57_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_12(sid_57_let, weight_1x1_conv2d_21_buffer_var, sid_58_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_13(sid_58_let, weight_depth_wise_21_buffer_var, sid_59_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_14(sid_59_let, weight_1x1_conv2d_linear_21_buffer_var, sid_60_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_15(sid_60_let, weight_1x1_conv2d_22_buffer_var, sid_61_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_16(sid_61_let, weight_depth_wise_22_buffer_var, sid_62_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_17(sid_62_let, weight_1x1_conv2d_linear_22_buffer_var, sid_63_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_18(sid_63_let, weight_1x1_conv2d_23_buffer_var, sid_64_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_19(sid_64_let, weight_depth_wise_23_buffer_var, sid_65_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_20(sid_65_let, weight_1x1_conv2d_linear_23_buffer_var, sid_66_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_21(sid_66_let, weight_1x1_conv2d_24_buffer_var, sid_67_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_22(sid_67_let, weight_depth_wise_24_buffer_var, sid_68_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_23(sid_68_let, weight_1x1_conv2d_linear_24_buffer_var, sid_69_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_24(sid_69_let, weight_1x1_conv2d_25_buffer_var, sid_70_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_25(sid_70_let, weight_depth_wise_25_buffer_var, sid_71_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_26(sid_71_let, weight_1x1_conv2d_linear_25_buffer_var, sid_72_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_27(sid_72_let, weight_1x1_conv2d_26_buffer_var, sid_73_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_28(sid_73_let, weight_depth_wise_26_buffer_var, sid_74_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_29(sid_74_let, weight_1x1_conv2d_linear_26_buffer_var, sid_75_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_30(sid_75_let, weight_1x1_conv2d_27_buffer_var, sid_76_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_31(sid_76_let, weight_depth_wise_27_buffer_var, sid_77_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_32(sid_77_let, weight_1x1_conv2d_linear_27_buffer_var, sid_78_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_33(sid_78_let, weight_1x1_conv2d_28_buffer_var, sid_79_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_34(sid_79_let, weight_depth_wise_28_buffer_var, sid_80_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_35(sid_80_let, weight_1x1_conv2d_linear_28_buffer_var, sid_81_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_36(sid_81_let, weight_1x1_conv2d_29_buffer_var, sid_82_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_37(sid_82_let, weight_depth_wise_29_buffer_var, sid_83_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_38(sid_83_let, weight_1x1_conv2d_linear_29_buffer_var, sid_84_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_39(sid_84_let, weight_1x1_conv2d_30_buffer_var, sid_85_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_40(sid_85_let, weight_depth_wise_30_buffer_var, sid_86_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_41(sid_86_let, weight_1x1_conv2d_linear_30_buffer_var, sid_87_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_42(sid_87_let, weight_1x1_conv2d_31_buffer_var, sid_88_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_43(sid_88_let, weight_depth_wise_31_buffer_var, sid_89_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_44(sid_89_let, weight_1x1_conv2d_linear_31_buffer_var, output_buffer_var, global_workspace_0_var) != 0 ) return -1;
  return 0;
}

