// tvm target: c -keys=partial_conv,arm_cpu,cpu -mcpu=cortex-m4+nodsp -model=nrf52840
#define TVM_EXPORTS
#include "tvm/runtime/c_runtime_api.h"
#include "tvm/runtime/c_backend_api.h"
#include <math.h>
#include <stdbool.h>
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_1_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_1(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_2_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_10(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_11_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_11(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_12_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_12(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_13_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_13(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_14_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_14(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_15_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_15(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_16_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_16(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_17_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_17(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_18_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_18(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_19_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_19(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_20_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_2(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_3_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_20(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_21_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_21(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_22_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_22(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_23_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_23(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_24_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_24(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_25_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_25(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_26_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_26(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_27_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_27(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_28_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_28(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_29_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_29(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_30_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_3(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_4_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_30(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_31_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_31(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_32_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_32(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_33_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_33(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_34_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_34(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_35_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_35(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_36_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_36(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_37_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_37(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_38_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_38(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_39_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_39(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_40_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_4(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_5_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_40(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_41_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_41(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_42_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_42(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_43_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_43(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_44_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_44(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_45_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_45(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_46_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_46(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_47_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_47(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_48_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_48(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_49_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_49(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_50_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_5(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_6_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_50(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_51_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_51(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_52_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_52(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_53_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_53(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_54_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_6(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_7_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_7(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_8_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_8(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_9_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_9(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_10_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default___tvm_main__(int8_t* data_buffer_var, int8_t* conv2d_1_buffer_var, int8_t* weight_depth_wise_1_buffer_var, int8_t* conv2d_2_buffer_var, int8_t* weight_1x1_conv2d_32_buffer_var, int8_t* weight_depth_wise_32_buffer_var, int8_t* weight_1x1_conv2d_linear_32_buffer_var, int8_t* weight_1x1_conv2d_33_buffer_var, int8_t* weight_depth_wise_33_buffer_var, int8_t* weight_1x1_conv2d_linear_33_buffer_var, int8_t* weight_1x1_conv2d_34_buffer_var, int8_t* weight_depth_wise_34_buffer_var, int8_t* weight_1x1_conv2d_linear_34_buffer_var, int8_t* weight_1x1_conv2d_35_buffer_var, int8_t* weight_depth_wise_35_buffer_var, int8_t* weight_1x1_conv2d_linear_35_buffer_var, int8_t* weight_1x1_conv2d_36_buffer_var, int8_t* weight_depth_wise_36_buffer_var, int8_t* weight_1x1_conv2d_linear_36_buffer_var, int8_t* weight_1x1_conv2d_37_buffer_var, int8_t* weight_depth_wise_37_buffer_var, int8_t* weight_1x1_conv2d_linear_37_buffer_var, int8_t* weight_1x1_conv2d_38_buffer_var, int8_t* weight_depth_wise_38_buffer_var, int8_t* weight_1x1_conv2d_linear_38_buffer_var, int8_t* weight_1x1_conv2d_39_buffer_var, int8_t* weight_depth_wise_39_buffer_var, int8_t* weight_1x1_conv2d_linear_39_buffer_var, int8_t* weight_1x1_conv2d_40_buffer_var, int8_t* weight_depth_wise_40_buffer_var, int8_t* weight_1x1_conv2d_linear_40_buffer_var, int8_t* weight_1x1_conv2d_41_buffer_var, int8_t* weight_depth_wise_41_buffer_var, int8_t* weight_1x1_conv2d_linear_41_buffer_var, int8_t* weight_1x1_conv2d_42_buffer_var, int8_t* weight_depth_wise_42_buffer_var, int8_t* weight_1x1_conv2d_linear_42_buffer_var, int8_t* weight_1x1_conv2d_43_buffer_var, int8_t* weight_depth_wise_43_buffer_var, int8_t* weight_1x1_conv2d_linear_43_buffer_var, int8_t* weight_1x1_conv2d_44_buffer_var, int8_t* weight_depth_wise_44_buffer_var, int8_t* weight_1x1_conv2d_linear_44_buffer_var, int8_t* weight_1x1_conv2d_45_buffer_var, int8_t* weight_depth_wise_45_buffer_var, int8_t* weight_1x1_conv2d_linear_45_buffer_var, int8_t* weight_1x1_conv2d_46_buffer_var, int8_t* weight_depth_wise_46_buffer_var, int8_t* weight_1x1_conv2d_linear_46_buffer_var, int8_t* weight_1x1_conv2d_47_buffer_var, int8_t* weight_depth_wise_47_buffer_var, int8_t* weight_1x1_conv2d_linear_47_buffer_var, int8_t* weight_1x1_conv2d_48_buffer_var, int8_t* weight_depth_wise_48_buffer_var, int8_t* weight_1x1_conv2d_linear_48_buffer_var, int8_t* output_buffer_var, uint8_t* global_workspace_0_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_1_var) {
  void* pad_temp_let = (&(global_workspace_1_var[0]));
  for (int32_t i1 = 0; i1 < 3; ++i1) {
    for (int32_t i2 = 0; i2 < 177; ++i2) {
      for (int32_t i3 = 0; i3 < 177; ++i3) {
        int8_t condval;
        if (((1 <= i2) && (1 <= i3))) {
          condval = p0[((((i1 * 30976) + (i2 * 176)) + i3) - 177)];
        } else {
          condval = (int8_t)0;
        }
        ((int8_t*)pad_temp_let)[(((i1 * 31329) + (i2 * 177)) + i3)] = condval;
      }
    }
  }
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 88; ++yy) {
      for (int32_t xx = 0; xx < 88; ++xx) {
        conv2d_nchw[(((ff * 7744) + (yy * 88)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 3; ++rc) {
          for (int32_t ry = 0; ry < 3; ++ry) {
            for (int32_t rx = 0; rx < 3; ++rx) {
              int32_t cse_var_1 = (((ff * 7744) + (yy * 88)) + xx);
              conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (((int8_t*)pad_temp_let)[(((((rc * 31329) + (yy * 354)) + (ry * 177)) + (xx * 2)) + rx)] * p1[((((ff * 27) + (rc * 9)) + (ry * 3)) + rx)]));
            }
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_1(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_2_var) {
  for (int32_t c = 0; c < 16; ++c) {
    for (int32_t i = 0; i < 88; ++i) {
      for (int32_t j = 0; j < 88; ++j) {
        DepthwiseConv2d[(((c * 7744) + (i * 88)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 7744);
            int32_t cse_var_1 = ((cse_var_2 + (i * 88)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 88) * 88)) + ((j + dj) % 88))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_10(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_11_var) {
  for (int32_t c = 0; c < 80; ++c) {
    for (int32_t i = 0; i < 44; ++i) {
      for (int32_t j = 0; j < 44; ++j) {
        DepthwiseConv2d[(((c * 1936) + (i * 44)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_2 = (c * 1936);
            int32_t cse_var_1 = ((cse_var_2 + (i * 44)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 44) * 44)) + ((j + dj) % 44))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_11(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_12_var) {
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 44; ++yy) {
      for (int32_t xx = 0; xx < 44; ++xx) {
        conv2d_nchw[(((ff * 1936) + (yy * 44)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 80; ++rc) {
          int32_t cse_var_2 = (yy * 44);
          int32_t cse_var_1 = (((ff * 1936) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1936) + cse_var_2) + xx)] * p1[((ff * 80) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_12(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_13_var) {
  for (int32_t ff = 0; ff < 64; ++ff) {
    for (int32_t yy = 0; yy < 44; ++yy) {
      for (int32_t xx = 0; xx < 44; ++xx) {
        conv2d_nchw[(((ff * 1936) + (yy * 44)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 44);
          int32_t cse_var_1 = (((ff * 1936) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1936) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_13(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_14_var) {
  for (int32_t c = 0; c < 64; ++c) {
    for (int32_t i = 0; i < 44; ++i) {
      for (int32_t j = 0; j < 44; ++j) {
        DepthwiseConv2d[(((c * 1936) + (i * 44)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 5; ++di) {
          for (int32_t dj = 0; dj < 5; ++dj) {
            int32_t cse_var_2 = (c * 1936);
            int32_t cse_var_1 = ((cse_var_2 + (i * 44)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 44) * 44)) + ((j + dj) % 44))] * p1[(((c * 25) + (di * 5)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_14(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_15_var) {
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 44; ++yy) {
      for (int32_t xx = 0; xx < 44; ++xx) {
        conv2d_nchw[(((ff * 1936) + (yy * 44)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 64; ++rc) {
          int32_t cse_var_2 = (yy * 44);
          int32_t cse_var_1 = (((ff * 1936) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1936) + cse_var_2) + xx)] * p1[((ff * 64) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_15(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_16_var) {
  for (int32_t ff = 0; ff < 80; ++ff) {
    for (int32_t yy = 0; yy < 44; ++yy) {
      for (int32_t xx = 0; xx < 44; ++xx) {
        conv2d_nchw[(((ff * 1936) + (yy * 44)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 44);
          int32_t cse_var_1 = (((ff * 1936) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1936) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_16(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_17_var) {
  for (int32_t c = 0; c < 80; ++c) {
    for (int32_t i = 0; i < 22; ++i) {
      for (int32_t j = 0; j < 22; ++j) {
        DepthwiseConv2d[(((c * 484) + (i * 22)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 5; ++di) {
          for (int32_t dj = 0; dj < 5; ++dj) {
            int32_t cse_var_1 = (((c * 484) + (i * 22)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 1936) + ((((i * 2) + di) % 44) * 44)) + (((j * 2) + dj) % 44))] * p1[(((c * 25) + (di * 5)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_17(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_18_var) {
  for (int32_t ff = 0; ff < 24; ++ff) {
    for (int32_t yy = 0; yy < 22; ++yy) {
      for (int32_t xx = 0; xx < 22; ++xx) {
        conv2d_nchw[(((ff * 484) + (yy * 22)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 80; ++rc) {
          int32_t cse_var_2 = (yy * 22);
          int32_t cse_var_1 = (((ff * 484) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 484) + cse_var_2) + xx)] * p1[((ff * 80) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_18(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_19_var) {
  for (int32_t ff = 0; ff < 120; ++ff) {
    for (int32_t yy = 0; yy < 22; ++yy) {
      for (int32_t xx = 0; xx < 22; ++xx) {
        conv2d_nchw[(((ff * 484) + (yy * 22)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 24; ++rc) {
          int32_t cse_var_2 = (yy * 22);
          int32_t cse_var_1 = (((ff * 484) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 484) + cse_var_2) + xx)] * p1[((ff * 24) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_19(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_20_var) {
  for (int32_t c = 0; c < 120; ++c) {
    for (int32_t i = 0; i < 22; ++i) {
      for (int32_t j = 0; j < 22; ++j) {
        DepthwiseConv2d[(((c * 484) + (i * 22)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 5; ++di) {
          for (int32_t dj = 0; dj < 5; ++dj) {
            int32_t cse_var_2 = (c * 484);
            int32_t cse_var_1 = ((cse_var_2 + (i * 22)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 22) * 22)) + ((j + dj) % 22))] * p1[(((c * 25) + (di * 5)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_2(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_3_var) {
  for (int32_t ff = 0; ff < 8; ++ff) {
    for (int32_t yy = 0; yy < 88; ++yy) {
      for (int32_t xx = 0; xx < 88; ++xx) {
        conv2d_nchw[(((ff * 7744) + (yy * 88)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 88);
          int32_t cse_var_1 = (((ff * 7744) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 7744) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_20(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_21_var) {
  for (int32_t ff = 0; ff < 24; ++ff) {
    for (int32_t yy = 0; yy < 22; ++yy) {
      for (int32_t xx = 0; xx < 22; ++xx) {
        conv2d_nchw[(((ff * 484) + (yy * 22)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 120; ++rc) {
          int32_t cse_var_2 = (yy * 22);
          int32_t cse_var_1 = (((ff * 484) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 484) + cse_var_2) + xx)] * p1[((ff * 120) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_21(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_22_var) {
  for (int32_t ff = 0; ff < 120; ++ff) {
    for (int32_t yy = 0; yy < 22; ++yy) {
      for (int32_t xx = 0; xx < 22; ++xx) {
        conv2d_nchw[(((ff * 484) + (yy * 22)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 24; ++rc) {
          int32_t cse_var_2 = (yy * 22);
          int32_t cse_var_1 = (((ff * 484) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 484) + cse_var_2) + xx)] * p1[((ff * 24) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_22(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_23_var) {
  for (int32_t c = 0; c < 120; ++c) {
    for (int32_t i = 0; i < 22; ++i) {
      for (int32_t j = 0; j < 22; ++j) {
        DepthwiseConv2d[(((c * 484) + (i * 22)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 5; ++di) {
          for (int32_t dj = 0; dj < 5; ++dj) {
            int32_t cse_var_2 = (c * 484);
            int32_t cse_var_1 = ((cse_var_2 + (i * 22)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 22) * 22)) + ((j + dj) % 22))] * p1[(((c * 25) + (di * 5)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_23(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_24_var) {
  for (int32_t ff = 0; ff < 24; ++ff) {
    for (int32_t yy = 0; yy < 22; ++yy) {
      for (int32_t xx = 0; xx < 22; ++xx) {
        conv2d_nchw[(((ff * 484) + (yy * 22)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 120; ++rc) {
          int32_t cse_var_2 = (yy * 22);
          int32_t cse_var_1 = (((ff * 484) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 484) + cse_var_2) + xx)] * p1[((ff * 120) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_24(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_25_var) {
  for (int32_t ff = 0; ff < 120; ++ff) {
    for (int32_t yy = 0; yy < 22; ++yy) {
      for (int32_t xx = 0; xx < 22; ++xx) {
        conv2d_nchw[(((ff * 484) + (yy * 22)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 24; ++rc) {
          int32_t cse_var_2 = (yy * 22);
          int32_t cse_var_1 = (((ff * 484) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 484) + cse_var_2) + xx)] * p1[((ff * 24) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_25(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_26_var) {
  for (int32_t c = 0; c < 120; ++c) {
    for (int32_t i = 0; i < 11; ++i) {
      for (int32_t j = 0; j < 11; ++j) {
        DepthwiseConv2d[(((c * 121) + (i * 11)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_1 = (((c * 121) + (i * 11)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 484) + ((((i * 2) + di) % 22) * 22)) + (((j * 2) + dj) % 22))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_26(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_27_var) {
  for (int32_t ff = 0; ff < 40; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 120; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 120) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_27(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_28_var) {
  for (int32_t ff = 0; ff < 240; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 40; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 40) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_28(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_29_var) {
  for (int32_t c = 0; c < 240; ++c) {
    for (int32_t i = 0; i < 11; ++i) {
      for (int32_t j = 0; j < 11; ++j) {
        DepthwiseConv2d[(((c * 121) + (i * 11)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_2 = (c * 121);
            int32_t cse_var_1 = ((cse_var_2 + (i * 11)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 11) * 11)) + ((j + dj) % 11))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_29(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_30_var) {
  for (int32_t ff = 0; ff < 40; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 240; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 240) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_3(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_4_var) {
  for (int32_t ff = 0; ff < 24; ++ff) {
    for (int32_t yy = 0; yy < 88; ++yy) {
      for (int32_t xx = 0; xx < 88; ++xx) {
        conv2d_nchw[(((ff * 7744) + (yy * 88)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 8; ++rc) {
          int32_t cse_var_2 = (yy * 88);
          int32_t cse_var_1 = (((ff * 7744) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 7744) + cse_var_2) + xx)] * p1[((ff * 8) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_30(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_31_var) {
  for (int32_t ff = 0; ff < 160; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 40; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 40) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_31(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_32_var) {
  for (int32_t c = 0; c < 160; ++c) {
    for (int32_t i = 0; i < 11; ++i) {
      for (int32_t j = 0; j < 11; ++j) {
        DepthwiseConv2d[(((c * 121) + (i * 11)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 5; ++di) {
          for (int32_t dj = 0; dj < 5; ++dj) {
            int32_t cse_var_2 = (c * 121);
            int32_t cse_var_1 = ((cse_var_2 + (i * 11)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 11) * 11)) + ((j + dj) % 11))] * p1[(((c * 25) + (di * 5)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_32(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_33_var) {
  for (int32_t ff = 0; ff < 40; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 160; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 160) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_33(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_34_var) {
  for (int32_t ff = 0; ff < 200; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 40; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 40) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_34(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_35_var) {
  for (int32_t c = 0; c < 200; ++c) {
    for (int32_t i = 0; i < 11; ++i) {
      for (int32_t j = 0; j < 11; ++j) {
        DepthwiseConv2d[(((c * 121) + (i * 11)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 5; ++di) {
          for (int32_t dj = 0; dj < 5; ++dj) {
            int32_t cse_var_2 = (c * 121);
            int32_t cse_var_1 = ((cse_var_2 + (i * 11)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 11) * 11)) + ((j + dj) % 11))] * p1[(((c * 25) + (di * 5)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_35(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_36_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 200; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 200) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_36(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_37_var) {
  for (int32_t ff = 0; ff < 240; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_37(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_38_var) {
  for (int32_t c = 0; c < 240; ++c) {
    for (int32_t i = 0; i < 11; ++i) {
      for (int32_t j = 0; j < 11; ++j) {
        DepthwiseConv2d[(((c * 121) + (i * 11)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_2 = (c * 121);
            int32_t cse_var_1 = ((cse_var_2 + (i * 11)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 11) * 11)) + ((j + dj) % 11))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_38(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_39_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 240; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 240) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_39(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_40_var) {
  for (int32_t ff = 0; ff < 240; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_4(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_5_var) {
  for (int32_t c = 0; c < 24; ++c) {
    for (int32_t i = 0; i < 44; ++i) {
      for (int32_t j = 0; j < 44; ++j) {
        DepthwiseConv2d[(((c * 1936) + (i * 44)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_1 = (((c * 1936) + (i * 44)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 7744) + ((((i * 2) + di) % 88) * 88)) + (((j * 2) + dj) % 88))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_40(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_41_var) {
  for (int32_t c = 0; c < 240; ++c) {
    for (int32_t i = 0; i < 11; ++i) {
      for (int32_t j = 0; j < 11; ++j) {
        DepthwiseConv2d[(((c * 121) + (i * 11)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 121);
            int32_t cse_var_1 = ((cse_var_2 + (i * 11)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 11) * 11)) + ((j + dj) % 11))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_41(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_42_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 240; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 240) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_42(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_43_var) {
  for (int32_t ff = 0; ff < 288; ++ff) {
    for (int32_t yy = 0; yy < 11; ++yy) {
      for (int32_t xx = 0; xx < 11; ++xx) {
        conv2d_nchw[(((ff * 121) + (yy * 11)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 11);
          int32_t cse_var_1 = (((ff * 121) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 121) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_43(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_44_var) {
  for (int32_t c = 0; c < 288; ++c) {
    for (int32_t i = 0; i < 6; ++i) {
      for (int32_t j = 0; j < 6; ++j) {
        DepthwiseConv2d[(((c * 36) + (i * 6)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_1 = (((c * 36) + (i * 6)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 121) + ((((i * 2) + di) % 11) * 11)) + (((j * 2) + dj) % 11))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_44(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_45_var) {
  for (int32_t ff = 0; ff < 96; ++ff) {
    for (int32_t yy = 0; yy < 6; ++yy) {
      for (int32_t xx = 0; xx < 6; ++xx) {
        conv2d_nchw[(((ff * 36) + (yy * 6)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 288; ++rc) {
          int32_t cse_var_2 = (yy * 6);
          int32_t cse_var_1 = (((ff * 36) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 36) + cse_var_2) + xx)] * p1[((ff * 288) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_45(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_46_var) {
  for (int32_t ff = 0; ff < 480; ++ff) {
    for (int32_t yy = 0; yy < 6; ++yy) {
      for (int32_t xx = 0; xx < 6; ++xx) {
        conv2d_nchw[(((ff * 36) + (yy * 6)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 96; ++rc) {
          int32_t cse_var_2 = (yy * 6);
          int32_t cse_var_1 = (((ff * 36) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 36) + cse_var_2) + xx)] * p1[((ff * 96) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_46(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_47_var) {
  for (int32_t c = 0; c < 480; ++c) {
    for (int32_t i = 0; i < 6; ++i) {
      for (int32_t j = 0; j < 6; ++j) {
        DepthwiseConv2d[(((c * 36) + (i * 6)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_2 = (c * 36);
            int32_t cse_var_1 = ((cse_var_2 + (i * 6)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 6) * 6)) + ((j + dj) % 6))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_47(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_48_var) {
  for (int32_t ff = 0; ff < 96; ++ff) {
    for (int32_t yy = 0; yy < 6; ++yy) {
      for (int32_t xx = 0; xx < 6; ++xx) {
        conv2d_nchw[(((ff * 36) + (yy * 6)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 480; ++rc) {
          int32_t cse_var_2 = (yy * 6);
          int32_t cse_var_1 = (((ff * 36) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 36) + cse_var_2) + xx)] * p1[((ff * 480) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_48(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_49_var) {
  for (int32_t ff = 0; ff < 384; ++ff) {
    for (int32_t yy = 0; yy < 6; ++yy) {
      for (int32_t xx = 0; xx < 6; ++xx) {
        conv2d_nchw[(((ff * 36) + (yy * 6)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 96; ++rc) {
          int32_t cse_var_2 = (yy * 6);
          int32_t cse_var_1 = (((ff * 36) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 36) + cse_var_2) + xx)] * p1[((ff * 96) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_49(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_50_var) {
  for (int32_t c = 0; c < 384; ++c) {
    for (int32_t i = 0; i < 6; ++i) {
      for (int32_t j = 0; j < 6; ++j) {
        DepthwiseConv2d[(((c * 36) + (i * 6)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 36);
            int32_t cse_var_1 = ((cse_var_2 + (i * 6)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 6) * 6)) + ((j + dj) % 6))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_5(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_6_var) {
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 44; ++yy) {
      for (int32_t xx = 0; xx < 44; ++xx) {
        conv2d_nchw[(((ff * 1936) + (yy * 44)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 24; ++rc) {
          int32_t cse_var_2 = (yy * 44);
          int32_t cse_var_1 = (((ff * 1936) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1936) + cse_var_2) + xx)] * p1[((ff * 24) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_50(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_51_var) {
  for (int32_t ff = 0; ff < 96; ++ff) {
    for (int32_t yy = 0; yy < 6; ++yy) {
      for (int32_t xx = 0; xx < 6; ++xx) {
        conv2d_nchw[(((ff * 36) + (yy * 6)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 384; ++rc) {
          int32_t cse_var_2 = (yy * 6);
          int32_t cse_var_1 = (((ff * 36) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 36) + cse_var_2) + xx)] * p1[((ff * 384) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_51(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_52_var) {
  for (int32_t ff = 0; ff < 480; ++ff) {
    for (int32_t yy = 0; yy < 6; ++yy) {
      for (int32_t xx = 0; xx < 6; ++xx) {
        conv2d_nchw[(((ff * 36) + (yy * 6)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 96; ++rc) {
          int32_t cse_var_2 = (yy * 6);
          int32_t cse_var_1 = (((ff * 36) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 36) + cse_var_2) + xx)] * p1[((ff * 96) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_52(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_53_var) {
  for (int32_t c = 0; c < 480; ++c) {
    for (int32_t i = 0; i < 6; ++i) {
      for (int32_t j = 0; j < 6; ++j) {
        DepthwiseConv2d[(((c * 36) + (i * 6)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 7; ++di) {
          for (int32_t dj = 0; dj < 7; ++dj) {
            int32_t cse_var_2 = (c * 36);
            int32_t cse_var_1 = ((cse_var_2 + (i * 6)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 6) * 6)) + ((j + dj) % 6))] * p1[(((c * 49) + (di * 7)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_53(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_54_var) {
  for (int32_t ff = 0; ff < 160; ++ff) {
    for (int32_t yy = 0; yy < 6; ++yy) {
      for (int32_t xx = 0; xx < 6; ++xx) {
        conv2d_nchw[(((ff * 36) + (yy * 6)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 480; ++rc) {
          int32_t cse_var_2 = (yy * 6);
          int32_t cse_var_1 = (((ff * 36) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 36) + cse_var_2) + xx)] * p1[((ff * 480) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_6(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_7_var) {
  for (int32_t ff = 0; ff < 80; ++ff) {
    for (int32_t yy = 0; yy < 44; ++yy) {
      for (int32_t xx = 0; xx < 44; ++xx) {
        conv2d_nchw[(((ff * 1936) + (yy * 44)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 44);
          int32_t cse_var_1 = (((ff * 1936) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1936) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_7(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_8_var) {
  for (int32_t c = 0; c < 80; ++c) {
    for (int32_t i = 0; i < 44; ++i) {
      for (int32_t j = 0; j < 44; ++j) {
        DepthwiseConv2d[(((c * 1936) + (i * 44)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 1936);
            int32_t cse_var_1 = ((cse_var_2 + (i * 44)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 44) * 44)) + ((j + dj) % 44))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_8(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_9_var) {
  for (int32_t ff = 0; ff < 16; ++ff) {
    for (int32_t yy = 0; yy < 44; ++yy) {
      for (int32_t xx = 0; xx < 44; ++xx) {
        conv2d_nchw[(((ff * 1936) + (yy * 44)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 80; ++rc) {
          int32_t cse_var_2 = (yy * 44);
          int32_t cse_var_1 = (((ff * 1936) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1936) + cse_var_2) + xx)] * p1[((ff * 80) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_9(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_10_var) {
  for (int32_t ff = 0; ff < 80; ++ff) {
    for (int32_t yy = 0; yy < 44; ++yy) {
      for (int32_t xx = 0; xx < 44; ++xx) {
        conv2d_nchw[(((ff * 1936) + (yy * 44)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 16; ++rc) {
          int32_t cse_var_2 = (yy * 44);
          int32_t cse_var_1 = (((ff * 1936) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1936) + cse_var_2) + xx)] * p1[((ff * 16) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default___tvm_main__(int8_t* data_buffer_var, int8_t* conv2d_1_buffer_var, int8_t* weight_depth_wise_1_buffer_var, int8_t* conv2d_2_buffer_var, int8_t* weight_1x1_conv2d_32_buffer_var, int8_t* weight_depth_wise_32_buffer_var, int8_t* weight_1x1_conv2d_linear_32_buffer_var, int8_t* weight_1x1_conv2d_33_buffer_var, int8_t* weight_depth_wise_33_buffer_var, int8_t* weight_1x1_conv2d_linear_33_buffer_var, int8_t* weight_1x1_conv2d_34_buffer_var, int8_t* weight_depth_wise_34_buffer_var, int8_t* weight_1x1_conv2d_linear_34_buffer_var, int8_t* weight_1x1_conv2d_35_buffer_var, int8_t* weight_depth_wise_35_buffer_var, int8_t* weight_1x1_conv2d_linear_35_buffer_var, int8_t* weight_1x1_conv2d_36_buffer_var, int8_t* weight_depth_wise_36_buffer_var, int8_t* weight_1x1_conv2d_linear_36_buffer_var, int8_t* weight_1x1_conv2d_37_buffer_var, int8_t* weight_depth_wise_37_buffer_var, int8_t* weight_1x1_conv2d_linear_37_buffer_var, int8_t* weight_1x1_conv2d_38_buffer_var, int8_t* weight_depth_wise_38_buffer_var, int8_t* weight_1x1_conv2d_linear_38_buffer_var, int8_t* weight_1x1_conv2d_39_buffer_var, int8_t* weight_depth_wise_39_buffer_var, int8_t* weight_1x1_conv2d_linear_39_buffer_var, int8_t* weight_1x1_conv2d_40_buffer_var, int8_t* weight_depth_wise_40_buffer_var, int8_t* weight_1x1_conv2d_linear_40_buffer_var, int8_t* weight_1x1_conv2d_41_buffer_var, int8_t* weight_depth_wise_41_buffer_var, int8_t* weight_1x1_conv2d_linear_41_buffer_var, int8_t* weight_1x1_conv2d_42_buffer_var, int8_t* weight_depth_wise_42_buffer_var, int8_t* weight_1x1_conv2d_linear_42_buffer_var, int8_t* weight_1x1_conv2d_43_buffer_var, int8_t* weight_depth_wise_43_buffer_var, int8_t* weight_1x1_conv2d_linear_43_buffer_var, int8_t* weight_1x1_conv2d_44_buffer_var, int8_t* weight_depth_wise_44_buffer_var, int8_t* weight_1x1_conv2d_linear_44_buffer_var, int8_t* weight_1x1_conv2d_45_buffer_var, int8_t* weight_depth_wise_45_buffer_var, int8_t* weight_1x1_conv2d_linear_45_buffer_var, int8_t* weight_1x1_conv2d_46_buffer_var, int8_t* weight_depth_wise_46_buffer_var, int8_t* weight_1x1_conv2d_linear_46_buffer_var, int8_t* weight_1x1_conv2d_47_buffer_var, int8_t* weight_depth_wise_47_buffer_var, int8_t* weight_1x1_conv2d_linear_47_buffer_var, int8_t* weight_1x1_conv2d_48_buffer_var, int8_t* weight_depth_wise_48_buffer_var, int8_t* weight_1x1_conv2d_linear_48_buffer_var, int8_t* output_buffer_var, uint8_t* global_workspace_0_var) {
  void* sid_89_let = (&(global_workspace_0_var[0]));
  void* sid_84_let = (&(global_workspace_0_var[38720]));
  void* sid_75_let = (&(global_workspace_0_var[116160]));
  void* sid_93_let = (&(global_workspace_0_var[58080]));
  void* sid_67_let = (&(global_workspace_0_var[123904]));
  void* sid_68_let = (&(global_workspace_0_var[0]));
  void* sid_74_let = (&(global_workspace_0_var[0]));
  void* sid_71_let = (&(global_workspace_0_var[154880]));
  void* sid_61_let = (&(global_workspace_0_var[154880]));
  void* sid_60_let = (&(global_workspace_0_var[0]));
  void* sid_69_let = (&(global_workspace_0_var[154880]));
  void* sid_59_let = (&(global_workspace_0_var[185856]));
  void* sid_78_let = (&(global_workspace_0_var[58080]));
  void* sid_58_let = (&(global_workspace_0_var[0]));
  void* sid_57_let = (&(global_workspace_0_var[185856]));
  void* sid_87_let = (&(global_workspace_0_var[19360]));
  void* sid_85_let = (&(global_workspace_0_var[19360]));
  void* sid_79_let = (&(global_workspace_0_var[0]));
  void* sid_65_let = (&(global_workspace_0_var[154880]));
  void* sid_62_let = (&(global_workspace_0_var[0]));
  void* sid_83_let = (&(global_workspace_0_var[0]));
  void* sid_76_let = (&(global_workspace_0_var[58080]));
  void* sid_77_let = (&(global_workspace_0_var[0]));
  void* sid_88_let = (&(global_workspace_0_var[24200]));
  void* sid_66_let = (&(global_workspace_0_var[0]));
  void* sid_63_let = (&(global_workspace_0_var[154880]));
  void* sid_90_let = (&(global_workspace_0_var[58080]));
  void* sid_81_let = (&(global_workspace_0_var[0]));
  void* sid_82_let = (&(global_workspace_0_var[29040]));
  void* sid_70_let = (&(global_workspace_0_var[0]));
  void* sid_80_let = (&(global_workspace_0_var[58080]));
  void* sid_72_let = (&(global_workspace_0_var[0]));
  void* sid_86_let = (&(global_workspace_0_var[0]));
  void* sid_55_let = (&(global_workspace_0_var[123904]));
  void* sid_100_let = (&(global_workspace_0_var[17280]));
  void* sid_64_let = (&(global_workspace_0_var[0]));
  void* sid_73_let = (&(global_workspace_0_var[58080]));
  void* sid_56_let = (&(global_workspace_0_var[0]));
  void* sid_91_let = (&(global_workspace_0_var[29040]));
  void* sid_92_let = (&(global_workspace_0_var[0]));
  void* sid_94_let = (&(global_workspace_0_var[29040]));
  void* sid_95_let = (&(global_workspace_0_var[0]));
  void* sid_96_let = (&(global_workspace_0_var[34848]));
  void* sid_97_let = (&(global_workspace_0_var[0]));
  void* sid_98_let = (&(global_workspace_0_var[34848]));
  void* sid_99_let = (&(global_workspace_0_var[0]));
  void* sid_101_let = (&(global_workspace_0_var[0]));
  void* sid_102_let = (&(global_workspace_0_var[27648]));
  void* sid_103_let = (&(global_workspace_0_var[13824]));
  void* sid_104_let = (&(global_workspace_0_var[0]));
  void* sid_105_let = (&(global_workspace_0_var[17280]));
  void* sid_106_let = (&(global_workspace_0_var[0]));
  void* sid_107_let = (&(global_workspace_0_var[17280]));
  if (tvmgen_default_fused_nn_conv2d(data_buffer_var, conv2d_1_buffer_var, sid_55_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_1(sid_55_let, weight_depth_wise_1_buffer_var, sid_56_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_2(sid_56_let, conv2d_2_buffer_var, sid_57_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_3(sid_57_let, weight_1x1_conv2d_32_buffer_var, sid_58_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_4(sid_58_let, weight_depth_wise_32_buffer_var, sid_59_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_5(sid_59_let, weight_1x1_conv2d_linear_32_buffer_var, sid_60_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_6(sid_60_let, weight_1x1_conv2d_33_buffer_var, sid_61_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_7(sid_61_let, weight_depth_wise_33_buffer_var, sid_62_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_8(sid_62_let, weight_1x1_conv2d_linear_33_buffer_var, sid_63_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_9(sid_63_let, weight_1x1_conv2d_34_buffer_var, sid_64_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_10(sid_64_let, weight_depth_wise_34_buffer_var, sid_65_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_11(sid_65_let, weight_1x1_conv2d_linear_34_buffer_var, sid_66_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_12(sid_66_let, weight_1x1_conv2d_35_buffer_var, sid_67_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_13(sid_67_let, weight_depth_wise_35_buffer_var, sid_68_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_14(sid_68_let, weight_1x1_conv2d_linear_35_buffer_var, sid_69_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_15(sid_69_let, weight_1x1_conv2d_36_buffer_var, sid_70_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_16(sid_70_let, weight_depth_wise_36_buffer_var, sid_71_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_17(sid_71_let, weight_1x1_conv2d_linear_36_buffer_var, sid_72_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_18(sid_72_let, weight_1x1_conv2d_37_buffer_var, sid_73_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_19(sid_73_let, weight_depth_wise_37_buffer_var, sid_74_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_20(sid_74_let, weight_1x1_conv2d_linear_37_buffer_var, sid_75_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_21(sid_75_let, weight_1x1_conv2d_38_buffer_var, sid_76_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_22(sid_76_let, weight_depth_wise_38_buffer_var, sid_77_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_23(sid_77_let, weight_1x1_conv2d_linear_38_buffer_var, sid_78_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_24(sid_78_let, weight_1x1_conv2d_39_buffer_var, sid_79_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_25(sid_79_let, weight_depth_wise_39_buffer_var, sid_80_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_26(sid_80_let, weight_1x1_conv2d_linear_39_buffer_var, sid_81_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_27(sid_81_let, weight_1x1_conv2d_40_buffer_var, sid_82_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_28(sid_82_let, weight_depth_wise_40_buffer_var, sid_83_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_29(sid_83_let, weight_1x1_conv2d_linear_40_buffer_var, sid_84_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_30(sid_84_let, weight_1x1_conv2d_41_buffer_var, sid_85_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_31(sid_85_let, weight_depth_wise_41_buffer_var, sid_86_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_32(sid_86_let, weight_1x1_conv2d_linear_41_buffer_var, sid_87_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_33(sid_87_let, weight_1x1_conv2d_42_buffer_var, sid_88_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_34(sid_88_let, weight_depth_wise_42_buffer_var, sid_89_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_35(sid_89_let, weight_1x1_conv2d_linear_42_buffer_var, sid_90_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_36(sid_90_let, weight_1x1_conv2d_43_buffer_var, sid_91_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_37(sid_91_let, weight_depth_wise_43_buffer_var, sid_92_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_38(sid_92_let, weight_1x1_conv2d_linear_43_buffer_var, sid_93_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_39(sid_93_let, weight_1x1_conv2d_44_buffer_var, sid_94_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_40(sid_94_let, weight_depth_wise_44_buffer_var, sid_95_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_41(sid_95_let, weight_1x1_conv2d_linear_44_buffer_var, sid_96_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_42(sid_96_let, weight_1x1_conv2d_45_buffer_var, sid_97_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_43(sid_97_let, weight_depth_wise_45_buffer_var, sid_98_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_44(sid_98_let, weight_1x1_conv2d_linear_45_buffer_var, sid_99_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_45(sid_99_let, weight_1x1_conv2d_46_buffer_var, sid_100_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_46(sid_100_let, weight_depth_wise_46_buffer_var, sid_101_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_47(sid_101_let, weight_1x1_conv2d_linear_46_buffer_var, sid_102_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_48(sid_102_let, weight_1x1_conv2d_47_buffer_var, sid_103_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_49(sid_103_let, weight_depth_wise_47_buffer_var, sid_104_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_50(sid_104_let, weight_1x1_conv2d_linear_47_buffer_var, sid_105_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_51(sid_105_let, weight_1x1_conv2d_48_buffer_var, sid_106_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_52(sid_106_let, weight_depth_wise_48_buffer_var, sid_107_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_53(sid_107_let, weight_1x1_conv2d_linear_48_buffer_var, output_buffer_var, global_workspace_0_var) != 0 ) return -1;
  return 0;
}

