// tvm target: c -keys=partial_conv,arm_cpu,cpu -mcpu=cortex-m4+nodsp -model=nrf52840
#define TVM_EXPORTS
#include "tvm/runtime/c_runtime_api.h"
#include "tvm/runtime/c_backend_api.h"
#include <math.h>
#include <stdbool.h>
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_1_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_1(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_2_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_10(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_11_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_11(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_12_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_12(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_13_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_13(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_14_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_14(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_15_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_15(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_16_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_16(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_17_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_17(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_18_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_18(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_19_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_19(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_20_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_2(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_3_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_20(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_21_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_21(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_22_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_22(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_23_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_23(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_24_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_24(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_25_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_25(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_26_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_26(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_27_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_27(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_28_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_28(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_29_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_29(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_30_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_3(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_4_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_30(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_31_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_31(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_32_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_32(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_33_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_33(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_34_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_34(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_35_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_35(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_36_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_36(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_37_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_37(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_38_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_38(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_39_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_39(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_40_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_4(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_5_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_40(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_41_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_41(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_42_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_42(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_43_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_43(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_44_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_44(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_45_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_45(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_46_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_46(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_47_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_47(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_48_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_48(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_49_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_49(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_50_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_5(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_6_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_50(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_51_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_51(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_52_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_52(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_53_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_6(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_7_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_7(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_8_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_8(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_9_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_9(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_10_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default___tvm_main__(int8_t* data_buffer_var, int8_t* conv2d_1_buffer_var, int8_t* weight_1x1_conv2d_1_buffer_var, int8_t* weight_depth_wise_1_buffer_var, int8_t* weight_1x1_conv2d_linear_1_buffer_var, int8_t* weight_1x1_conv2d_2_buffer_var, int8_t* weight_depth_wise_2_buffer_var, int8_t* weight_1x1_conv2d_linear_2_buffer_var, int8_t* weight_1x1_conv2d_3_buffer_var, int8_t* weight_depth_wise_3_buffer_var, int8_t* weight_1x1_conv2d_linear_3_buffer_var, int8_t* weight_1x1_conv2d_4_buffer_var, int8_t* weight_depth_wise_4_buffer_var, int8_t* weight_1x1_conv2d_linear_4_buffer_var, int8_t* weight_1x1_conv2d_5_buffer_var, int8_t* weight_depth_wise_5_buffer_var, int8_t* weight_1x1_conv2d_linear_5_buffer_var, int8_t* weight_1x1_conv2d_6_buffer_var, int8_t* weight_depth_wise_6_buffer_var, int8_t* weight_1x1_conv2d_linear_6_buffer_var, int8_t* weight_1x1_conv2d_7_buffer_var, int8_t* weight_depth_wise_7_buffer_var, int8_t* weight_1x1_conv2d_linear_7_buffer_var, int8_t* weight_1x1_conv2d_8_buffer_var, int8_t* weight_depth_wise_8_buffer_var, int8_t* weight_1x1_conv2d_linear_8_buffer_var, int8_t* weight_1x1_conv2d_9_buffer_var, int8_t* weight_depth_wise_9_buffer_var, int8_t* weight_1x1_conv2d_linear_9_buffer_var, int8_t* weight_1x1_conv2d_10_buffer_var, int8_t* weight_depth_wise_10_buffer_var, int8_t* weight_1x1_conv2d_linear_10_buffer_var, int8_t* weight_1x1_conv2d_11_buffer_var, int8_t* weight_depth_wise_11_buffer_var, int8_t* weight_1x1_conv2d_linear_11_buffer_var, int8_t* weight_1x1_conv2d_12_buffer_var, int8_t* weight_depth_wise_12_buffer_var, int8_t* weight_1x1_conv2d_linear_12_buffer_var, int8_t* weight_1x1_conv2d_13_buffer_var, int8_t* weight_depth_wise_13_buffer_var, int8_t* weight_1x1_conv2d_linear_13_buffer_var, int8_t* weight_1x1_conv2d_14_buffer_var, int8_t* weight_depth_wise_14_buffer_var, int8_t* weight_1x1_conv2d_linear_14_buffer_var, int8_t* weight_1x1_conv2d_15_buffer_var, int8_t* weight_depth_wise_15_buffer_var, int8_t* weight_1x1_conv2d_linear_15_buffer_var, int8_t* weight_1x1_conv2d_16_buffer_var, int8_t* weight_depth_wise_16_buffer_var, int8_t* weight_1x1_conv2d_linear_16_buffer_var, int8_t* weight_1x1_conv2d_17_buffer_var, int8_t* weight_depth_wise_17_buffer_var, int8_t* weight_1x1_conv2d_linear_17_buffer_var, int8_t* conv2d_2_buffer_var, int8_t* output_buffer_var, uint8_t* global_workspace_0_var);
#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_1_var) {
  void* pad_temp_let = (&(global_workspace_1_var[0]));
  for (int32_t i1 = 0; i1 < 3; ++i1) {
    for (int32_t i2 = 0; i2 < 145; ++i2) {
      for (int32_t i3 = 0; i3 < 145; ++i3) {
        int8_t condval;
        if (((1 <= i2) && (1 <= i3))) {
          condval = p0[((((i1 * 20736) + (i2 * 144)) + i3) - 145)];
        } else {
          condval = (int8_t)0;
        }
        ((int8_t*)pad_temp_let)[(((i1 * 21025) + (i2 * 145)) + i3)] = condval;
      }
    }
  }
  for (int32_t ff = 0; ff < 11; ++ff) {
    for (int32_t yy = 0; yy < 72; ++yy) {
      for (int32_t xx = 0; xx < 72; ++xx) {
        conv2d_nchw[(((ff * 5184) + (yy * 72)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 3; ++rc) {
          for (int32_t ry = 0; ry < 3; ++ry) {
            for (int32_t rx = 0; rx < 3; ++rx) {
              int32_t cse_var_1 = (((ff * 5184) + (yy * 72)) + xx);
              conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (((int8_t*)pad_temp_let)[(((((rc * 21025) + (yy * 290)) + (ry * 145)) + (xx * 2)) + rx)] * p1[((((ff * 27) + (rc * 9)) + (ry * 3)) + rx)]));
            }
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_1(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_2_var) {
  for (int32_t ff = 0; ff < 11; ++ff) {
    for (int32_t yy = 0; yy < 72; ++yy) {
      for (int32_t xx = 0; xx < 72; ++xx) {
        conv2d_nchw[(((ff * 5184) + (yy * 72)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 11; ++rc) {
          int32_t cse_var_2 = (yy * 72);
          int32_t cse_var_1 = (((ff * 5184) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 5184) + cse_var_2) + xx)] * p1[((ff * 11) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_10(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_11_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 36; ++yy) {
      for (int32_t xx = 0; xx < 36; ++xx) {
        conv2d_nchw[(((ff * 1296) + (yy * 36)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 8; ++rc) {
          int32_t cse_var_2 = (yy * 36);
          int32_t cse_var_1 = (((ff * 1296) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1296) + cse_var_2) + xx)] * p1[((ff * 8) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_11(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_12_var) {
  for (int32_t c = 0; c < 48; ++c) {
    for (int32_t i = 0; i < 18; ++i) {
      for (int32_t j = 0; j < 18; ++j) {
        DepthwiseConv2d[(((c * 324) + (i * 18)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_1 = (((c * 324) + (i * 18)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 1296) + ((((i * 2) + di) % 36) * 36)) + (((j * 2) + dj) % 36))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_12(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_13_var) {
  for (int32_t ff = 0; ff < 11; ++ff) {
    for (int32_t yy = 0; yy < 18; ++yy) {
      for (int32_t xx = 0; xx < 18; ++xx) {
        conv2d_nchw[(((ff * 324) + (yy * 18)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 18);
          int32_t cse_var_1 = (((ff * 324) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 324) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_13(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_14_var) {
  for (int32_t ff = 0; ff < 66; ++ff) {
    for (int32_t yy = 0; yy < 18; ++yy) {
      for (int32_t xx = 0; xx < 18; ++xx) {
        conv2d_nchw[(((ff * 324) + (yy * 18)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 11; ++rc) {
          int32_t cse_var_2 = (yy * 18);
          int32_t cse_var_1 = (((ff * 324) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 324) + cse_var_2) + xx)] * p1[((ff * 11) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_14(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_15_var) {
  for (int32_t c = 0; c < 66; ++c) {
    for (int32_t i = 0; i < 18; ++i) {
      for (int32_t j = 0; j < 18; ++j) {
        DepthwiseConv2d[(((c * 324) + (i * 18)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 324);
            int32_t cse_var_1 = ((cse_var_2 + (i * 18)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 18) * 18)) + ((j + dj) % 18))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_15(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_16_var) {
  for (int32_t ff = 0; ff < 11; ++ff) {
    for (int32_t yy = 0; yy < 18; ++yy) {
      for (int32_t xx = 0; xx < 18; ++xx) {
        conv2d_nchw[(((ff * 324) + (yy * 18)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 66; ++rc) {
          int32_t cse_var_2 = (yy * 18);
          int32_t cse_var_1 = (((ff * 324) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 324) + cse_var_2) + xx)] * p1[((ff * 66) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_16(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_17_var) {
  for (int32_t ff = 0; ff < 66; ++ff) {
    for (int32_t yy = 0; yy < 18; ++yy) {
      for (int32_t xx = 0; xx < 18; ++xx) {
        conv2d_nchw[(((ff * 324) + (yy * 18)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 11; ++rc) {
          int32_t cse_var_2 = (yy * 18);
          int32_t cse_var_1 = (((ff * 324) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 324) + cse_var_2) + xx)] * p1[((ff * 11) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_17(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_18_var) {
  for (int32_t c = 0; c < 66; ++c) {
    for (int32_t i = 0; i < 18; ++i) {
      for (int32_t j = 0; j < 18; ++j) {
        DepthwiseConv2d[(((c * 324) + (i * 18)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 324);
            int32_t cse_var_1 = ((cse_var_2 + (i * 18)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 18) * 18)) + ((j + dj) % 18))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_18(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_19_var) {
  for (int32_t ff = 0; ff < 11; ++ff) {
    for (int32_t yy = 0; yy < 18; ++yy) {
      for (int32_t xx = 0; xx < 18; ++xx) {
        conv2d_nchw[(((ff * 324) + (yy * 18)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 66; ++rc) {
          int32_t cse_var_2 = (yy * 18);
          int32_t cse_var_1 = (((ff * 324) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 324) + cse_var_2) + xx)] * p1[((ff * 66) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_19(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_20_var) {
  for (int32_t ff = 0; ff < 66; ++ff) {
    for (int32_t yy = 0; yy < 18; ++yy) {
      for (int32_t xx = 0; xx < 18; ++xx) {
        conv2d_nchw[(((ff * 324) + (yy * 18)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 11; ++rc) {
          int32_t cse_var_2 = (yy * 18);
          int32_t cse_var_1 = (((ff * 324) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 324) + cse_var_2) + xx)] * p1[((ff * 11) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_2(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_3_var) {
  for (int32_t c = 0; c < 11; ++c) {
    for (int32_t i = 0; i < 72; ++i) {
      for (int32_t j = 0; j < 72; ++j) {
        DepthwiseConv2d[(((c * 5184) + (i * 72)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 5184);
            int32_t cse_var_1 = ((cse_var_2 + (i * 72)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 72) * 72)) + ((j + dj) % 72))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_20(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_21_var) {
  for (int32_t c = 0; c < 66; ++c) {
    for (int32_t i = 0; i < 9; ++i) {
      for (int32_t j = 0; j < 9; ++j) {
        DepthwiseConv2d[(((c * 81) + (i * 9)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_1 = (((c * 81) + (i * 9)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 324) + ((((i * 2) + di) % 18) * 18)) + (((j * 2) + dj) % 18))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_21(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_22_var) {
  for (int32_t ff = 0; ff < 22; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 66; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 66) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_22(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_23_var) {
  for (int32_t ff = 0; ff < 132; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 22; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 22) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_23(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_24_var) {
  for (int32_t c = 0; c < 132; ++c) {
    for (int32_t i = 0; i < 9; ++i) {
      for (int32_t j = 0; j < 9; ++j) {
        DepthwiseConv2d[(((c * 81) + (i * 9)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 81);
            int32_t cse_var_1 = ((cse_var_2 + (i * 9)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 9) * 9)) + ((j + dj) % 9))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_24(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_25_var) {
  for (int32_t ff = 0; ff < 22; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 132; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 132) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_25(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_26_var) {
  for (int32_t ff = 0; ff < 132; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 22; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 22) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_26(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_27_var) {
  for (int32_t c = 0; c < 132; ++c) {
    for (int32_t i = 0; i < 9; ++i) {
      for (int32_t j = 0; j < 9; ++j) {
        DepthwiseConv2d[(((c * 81) + (i * 9)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 81);
            int32_t cse_var_1 = ((cse_var_2 + (i * 9)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 9) * 9)) + ((j + dj) % 9))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_27(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_28_var) {
  for (int32_t ff = 0; ff < 22; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 132; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 132) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_28(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_29_var) {
  for (int32_t ff = 0; ff < 132; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 22; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 22) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_29(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_30_var) {
  for (int32_t c = 0; c < 132; ++c) {
    for (int32_t i = 0; i < 9; ++i) {
      for (int32_t j = 0; j < 9; ++j) {
        DepthwiseConv2d[(((c * 81) + (i * 9)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 81);
            int32_t cse_var_1 = ((cse_var_2 + (i * 9)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 9) * 9)) + ((j + dj) % 9))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_3(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_4_var) {
  for (int32_t ff = 0; ff < 5; ++ff) {
    for (int32_t yy = 0; yy < 72; ++yy) {
      for (int32_t xx = 0; xx < 72; ++xx) {
        conv2d_nchw[(((ff * 5184) + (yy * 72)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 11; ++rc) {
          int32_t cse_var_2 = (yy * 72);
          int32_t cse_var_1 = (((ff * 5184) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 5184) + cse_var_2) + xx)] * p1[((ff * 11) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_30(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_31_var) {
  for (int32_t ff = 0; ff < 22; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 132; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 132) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_31(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_32_var) {
  for (int32_t ff = 0; ff < 132; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 22; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 22) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_32(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_33_var) {
  for (int32_t c = 0; c < 132; ++c) {
    for (int32_t i = 0; i < 9; ++i) {
      for (int32_t j = 0; j < 9; ++j) {
        DepthwiseConv2d[(((c * 81) + (i * 9)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 81);
            int32_t cse_var_1 = ((cse_var_2 + (i * 9)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 9) * 9)) + ((j + dj) % 9))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_33(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_34_var) {
  for (int32_t ff = 0; ff < 33; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 132; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 132) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_34(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_35_var) {
  for (int32_t ff = 0; ff < 198; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 33; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 33) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_35(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_36_var) {
  for (int32_t c = 0; c < 198; ++c) {
    for (int32_t i = 0; i < 9; ++i) {
      for (int32_t j = 0; j < 9; ++j) {
        DepthwiseConv2d[(((c * 81) + (i * 9)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 81);
            int32_t cse_var_1 = ((cse_var_2 + (i * 9)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 9) * 9)) + ((j + dj) % 9))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_36(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_37_var) {
  for (int32_t ff = 0; ff < 33; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 198; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 198) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_37(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_38_var) {
  for (int32_t ff = 0; ff < 198; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 33; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 33) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_38(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_39_var) {
  for (int32_t c = 0; c < 198; ++c) {
    for (int32_t i = 0; i < 9; ++i) {
      for (int32_t j = 0; j < 9; ++j) {
        DepthwiseConv2d[(((c * 81) + (i * 9)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 81);
            int32_t cse_var_1 = ((cse_var_2 + (i * 9)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 9) * 9)) + ((j + dj) % 9))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_39(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_40_var) {
  for (int32_t ff = 0; ff < 33; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 198; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 198) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_4(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_5_var) {
  for (int32_t ff = 0; ff < 30; ++ff) {
    for (int32_t yy = 0; yy < 72; ++yy) {
      for (int32_t xx = 0; xx < 72; ++xx) {
        conv2d_nchw[(((ff * 5184) + (yy * 72)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 5; ++rc) {
          int32_t cse_var_2 = (yy * 72);
          int32_t cse_var_1 = (((ff * 5184) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 5184) + cse_var_2) + xx)] * p1[((ff * 5) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_40(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_41_var) {
  for (int32_t ff = 0; ff < 198; ++ff) {
    for (int32_t yy = 0; yy < 9; ++yy) {
      for (int32_t xx = 0; xx < 9; ++xx) {
        conv2d_nchw[(((ff * 81) + (yy * 9)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 33; ++rc) {
          int32_t cse_var_2 = (yy * 9);
          int32_t cse_var_1 = (((ff * 81) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 81) + cse_var_2) + xx)] * p1[((ff * 33) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_41(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_42_var) {
  for (int32_t c = 0; c < 198; ++c) {
    for (int32_t i = 0; i < 5; ++i) {
      for (int32_t j = 0; j < 5; ++j) {
        DepthwiseConv2d[(((c * 25) + (i * 5)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_1 = (((c * 25) + (i * 5)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 81) + ((((i * 2) + di) % 9) * 9)) + (((j * 2) + dj) % 9))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_42(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_43_var) {
  for (int32_t ff = 0; ff < 56; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 198; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 198) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_43(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_44_var) {
  for (int32_t ff = 0; ff < 336; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 56; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 56) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_44(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_45_var) {
  for (int32_t c = 0; c < 336; ++c) {
    for (int32_t i = 0; i < 5; ++i) {
      for (int32_t j = 0; j < 5; ++j) {
        DepthwiseConv2d[(((c * 25) + (i * 5)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 25);
            int32_t cse_var_1 = ((cse_var_2 + (i * 5)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 5) * 5)) + ((j + dj) % 5))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_45(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_46_var) {
  for (int32_t ff = 0; ff < 56; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 336; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 336) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_46(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_47_var) {
  for (int32_t ff = 0; ff < 336; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 56; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 56) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_47(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_48_var) {
  for (int32_t c = 0; c < 336; ++c) {
    for (int32_t i = 0; i < 5; ++i) {
      for (int32_t j = 0; j < 5; ++j) {
        DepthwiseConv2d[(((c * 25) + (i * 5)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 25);
            int32_t cse_var_1 = ((cse_var_2 + (i * 5)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 5) * 5)) + ((j + dj) % 5))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_48(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_49_var) {
  for (int32_t ff = 0; ff < 56; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 336; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 336) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_49(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_50_var) {
  for (int32_t ff = 0; ff < 336; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 56; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 56) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_5(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_6_var) {
  for (int32_t c = 0; c < 30; ++c) {
    for (int32_t i = 0; i < 36; ++i) {
      for (int32_t j = 0; j < 36; ++j) {
        DepthwiseConv2d[(((c * 1296) + (i * 36)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_1 = (((c * 1296) + (i * 36)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[(((c * 5184) + ((((i * 2) + di) % 72) * 72)) + (((j * 2) + dj) % 72))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_50(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_51_var) {
  for (int32_t c = 0; c < 336; ++c) {
    for (int32_t i = 0; i < 5; ++i) {
      for (int32_t j = 0; j < 5; ++j) {
        DepthwiseConv2d[(((c * 25) + (i * 5)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 25);
            int32_t cse_var_1 = ((cse_var_2 + (i * 5)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 5) * 5)) + ((j + dj) % 5))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_51(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_52_var) {
  for (int32_t ff = 0; ff < 112; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 336; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 336) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_52(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_53_var) {
  for (int32_t ff = 0; ff < 448; ++ff) {
    for (int32_t yy = 0; yy < 5; ++yy) {
      for (int32_t xx = 0; xx < 5; ++xx) {
        conv2d_nchw[(((ff * 25) + (yy * 5)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 112; ++rc) {
          int32_t cse_var_2 = (yy * 5);
          int32_t cse_var_1 = (((ff * 25) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 25) + cse_var_2) + xx)] * p1[((ff * 112) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_6(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_7_var) {
  for (int32_t ff = 0; ff < 8; ++ff) {
    for (int32_t yy = 0; yy < 36; ++yy) {
      for (int32_t xx = 0; xx < 36; ++xx) {
        conv2d_nchw[(((ff * 1296) + (yy * 36)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 30; ++rc) {
          int32_t cse_var_2 = (yy * 36);
          int32_t cse_var_1 = (((ff * 1296) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1296) + cse_var_2) + xx)] * p1[((ff * 30) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_7(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_8_var) {
  for (int32_t ff = 0; ff < 48; ++ff) {
    for (int32_t yy = 0; yy < 36; ++yy) {
      for (int32_t xx = 0; xx < 36; ++xx) {
        conv2d_nchw[(((ff * 1296) + (yy * 36)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 8; ++rc) {
          int32_t cse_var_2 = (yy * 36);
          int32_t cse_var_1 = (((ff * 1296) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1296) + cse_var_2) + xx)] * p1[((ff * 8) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_8(int8_t* p0, int8_t* p1, int8_t* DepthwiseConv2d, uint8_t* global_workspace_9_var) {
  for (int32_t c = 0; c < 48; ++c) {
    for (int32_t i = 0; i < 36; ++i) {
      for (int32_t j = 0; j < 36; ++j) {
        DepthwiseConv2d[(((c * 1296) + (i * 36)) + j)] = (int8_t)0;
        for (int32_t di = 0; di < 3; ++di) {
          for (int32_t dj = 0; dj < 3; ++dj) {
            int32_t cse_var_2 = (c * 1296);
            int32_t cse_var_1 = ((cse_var_2 + (i * 36)) + j);
            DepthwiseConv2d[cse_var_1] = (DepthwiseConv2d[cse_var_1] + (p0[((cse_var_2 + (((i + di) % 36) * 36)) + ((j + dj) % 36))] * p1[(((c * 9) + (di * 3)) + dj)]));
          }
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default_fused_nn_conv2d_9(int8_t* p0, int8_t* p1, int8_t* conv2d_nchw, uint8_t* global_workspace_10_var) {
  for (int32_t ff = 0; ff < 8; ++ff) {
    for (int32_t yy = 0; yy < 36; ++yy) {
      for (int32_t xx = 0; xx < 36; ++xx) {
        conv2d_nchw[(((ff * 1296) + (yy * 36)) + xx)] = (int8_t)0;
        for (int32_t rc = 0; rc < 48; ++rc) {
          int32_t cse_var_2 = (yy * 36);
          int32_t cse_var_1 = (((ff * 1296) + cse_var_2) + xx);
          conv2d_nchw[cse_var_1] = (conv2d_nchw[cse_var_1] + (p0[(((rc * 1296) + cse_var_2) + xx)] * p1[((ff * 48) + rc)]));
        }
      }
    }
  }
  return 0;
}

#ifdef __cplusplus
extern "C"
#endif
TVM_DLL int32_t tvmgen_default___tvm_main__(int8_t* data_buffer_var, int8_t* conv2d_1_buffer_var, int8_t* weight_1x1_conv2d_1_buffer_var, int8_t* weight_depth_wise_1_buffer_var, int8_t* weight_1x1_conv2d_linear_1_buffer_var, int8_t* weight_1x1_conv2d_2_buffer_var, int8_t* weight_depth_wise_2_buffer_var, int8_t* weight_1x1_conv2d_linear_2_buffer_var, int8_t* weight_1x1_conv2d_3_buffer_var, int8_t* weight_depth_wise_3_buffer_var, int8_t* weight_1x1_conv2d_linear_3_buffer_var, int8_t* weight_1x1_conv2d_4_buffer_var, int8_t* weight_depth_wise_4_buffer_var, int8_t* weight_1x1_conv2d_linear_4_buffer_var, int8_t* weight_1x1_conv2d_5_buffer_var, int8_t* weight_depth_wise_5_buffer_var, int8_t* weight_1x1_conv2d_linear_5_buffer_var, int8_t* weight_1x1_conv2d_6_buffer_var, int8_t* weight_depth_wise_6_buffer_var, int8_t* weight_1x1_conv2d_linear_6_buffer_var, int8_t* weight_1x1_conv2d_7_buffer_var, int8_t* weight_depth_wise_7_buffer_var, int8_t* weight_1x1_conv2d_linear_7_buffer_var, int8_t* weight_1x1_conv2d_8_buffer_var, int8_t* weight_depth_wise_8_buffer_var, int8_t* weight_1x1_conv2d_linear_8_buffer_var, int8_t* weight_1x1_conv2d_9_buffer_var, int8_t* weight_depth_wise_9_buffer_var, int8_t* weight_1x1_conv2d_linear_9_buffer_var, int8_t* weight_1x1_conv2d_10_buffer_var, int8_t* weight_depth_wise_10_buffer_var, int8_t* weight_1x1_conv2d_linear_10_buffer_var, int8_t* weight_1x1_conv2d_11_buffer_var, int8_t* weight_depth_wise_11_buffer_var, int8_t* weight_1x1_conv2d_linear_11_buffer_var, int8_t* weight_1x1_conv2d_12_buffer_var, int8_t* weight_depth_wise_12_buffer_var, int8_t* weight_1x1_conv2d_linear_12_buffer_var, int8_t* weight_1x1_conv2d_13_buffer_var, int8_t* weight_depth_wise_13_buffer_var, int8_t* weight_1x1_conv2d_linear_13_buffer_var, int8_t* weight_1x1_conv2d_14_buffer_var, int8_t* weight_depth_wise_14_buffer_var, int8_t* weight_1x1_conv2d_linear_14_buffer_var, int8_t* weight_1x1_conv2d_15_buffer_var, int8_t* weight_depth_wise_15_buffer_var, int8_t* weight_1x1_conv2d_linear_15_buffer_var, int8_t* weight_1x1_conv2d_16_buffer_var, int8_t* weight_depth_wise_16_buffer_var, int8_t* weight_1x1_conv2d_linear_16_buffer_var, int8_t* weight_1x1_conv2d_17_buffer_var, int8_t* weight_depth_wise_17_buffer_var, int8_t* weight_1x1_conv2d_linear_17_buffer_var, int8_t* conv2d_2_buffer_var, int8_t* output_buffer_var, uint8_t* global_workspace_0_var) {
  void* sid_83_let = (&(global_workspace_0_var[0]));
  void* sid_81_let = (&(global_workspace_0_var[21384]));
  void* sid_79_let = (&(global_workspace_0_var[10692]));
  void* sid_80_let = (&(global_workspace_0_var[0]));
  void* sid_77_let = (&(global_workspace_0_var[0]));
  void* sid_74_let = (&(global_workspace_0_var[21384]));
  void* sid_73_let = (&(global_workspace_0_var[0]));
  void* sid_84_let = (&(global_workspace_0_var[21384]));
  void* sid_71_let = (&(global_workspace_0_var[0]));
  void* sid_66_let = (&(global_workspace_0_var[0]));
  void* sid_64_let = (&(global_workspace_0_var[0]));
  void* sid_63_let = (&(global_workspace_0_var[62208]));
  void* sid_54_let = (&(global_workspace_0_var[114048]));
  void* sid_61_let = (&(global_workspace_0_var[62208]));
  void* sid_60_let = (&(global_workspace_0_var[0]));
  void* sid_86_let = (&(global_workspace_0_var[0]));
  void* sid_87_let = (&(global_workspace_0_var[10692]));
  void* sid_93_let = (&(global_workspace_0_var[16040]));
  void* sid_89_let = (&(global_workspace_0_var[0]));
  void* sid_57_let = (&(global_workspace_0_var[155520]));
  void* sid_58_let = (&(global_workspace_0_var[0]));
  void* sid_88_let = (&(global_workspace_0_var[16040]));
  void* sid_75_let = (&(global_workspace_0_var[0]));
  void* sid_67_let = (&(global_workspace_0_var[21384]));
  void* sid_98_let = (&(global_workspace_0_var[0]));
  void* sid_56_let = (&(global_workspace_0_var[0]));
  void* sid_68_let = (&(global_workspace_0_var[0]));
  void* sid_70_let = (&(global_workspace_0_var[21384]));
  void* sid_65_let = (&(global_workspace_0_var[62208]));
  void* sid_72_let = (&(global_workspace_0_var[21384]));
  void* sid_69_let = (&(global_workspace_0_var[42768]));
  void* sid_82_let = (&(global_workspace_0_var[10692]));
  void* sid_76_let = (&(global_workspace_0_var[10692]));
  void* sid_85_let = (&(global_workspace_0_var[10692]));
  void* sid_59_let = (&(global_workspace_0_var[155520]));
  void* sid_78_let = (&(global_workspace_0_var[21384]));
  void* sid_62_let = (&(global_workspace_0_var[0]));
  void* sid_55_let = (&(global_workspace_0_var[57024]));
  void* sid_90_let = (&(global_workspace_0_var[32080]));
  void* sid_91_let = (&(global_workspace_0_var[16040]));
  void* sid_92_let = (&(global_workspace_0_var[0]));
  void* sid_101_let = (&(global_workspace_0_var[0]));
  void* sid_94_let = (&(global_workspace_0_var[0]));
  void* sid_95_let = (&(global_workspace_0_var[16040]));
  void* sid_96_let = (&(global_workspace_0_var[0]));
  void* sid_97_let = (&(global_workspace_0_var[8400]));
  void* sid_99_let = (&(global_workspace_0_var[16800]));
  void* sid_100_let = (&(global_workspace_0_var[8400]));
  void* sid_102_let = (&(global_workspace_0_var[16800]));
  void* sid_103_let = (&(global_workspace_0_var[8400]));
  void* sid_104_let = (&(global_workspace_0_var[0]));
  void* sid_105_let = (&(global_workspace_0_var[8400]));
  if (tvmgen_default_fused_nn_conv2d(data_buffer_var, conv2d_1_buffer_var, sid_54_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_1(sid_54_let, weight_1x1_conv2d_1_buffer_var, sid_55_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_2(sid_55_let, weight_depth_wise_1_buffer_var, sid_56_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_3(sid_56_let, weight_1x1_conv2d_linear_1_buffer_var, sid_57_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_4(sid_57_let, weight_1x1_conv2d_2_buffer_var, sid_58_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_5(sid_58_let, weight_depth_wise_2_buffer_var, sid_59_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_6(sid_59_let, weight_1x1_conv2d_linear_2_buffer_var, sid_60_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_7(sid_60_let, weight_1x1_conv2d_3_buffer_var, sid_61_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_8(sid_61_let, weight_depth_wise_3_buffer_var, sid_62_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_9(sid_62_let, weight_1x1_conv2d_linear_3_buffer_var, sid_63_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_10(sid_63_let, weight_1x1_conv2d_4_buffer_var, sid_64_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_11(sid_64_let, weight_depth_wise_4_buffer_var, sid_65_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_12(sid_65_let, weight_1x1_conv2d_linear_4_buffer_var, sid_66_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_13(sid_66_let, weight_1x1_conv2d_5_buffer_var, sid_67_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_14(sid_67_let, weight_depth_wise_5_buffer_var, sid_68_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_15(sid_68_let, weight_1x1_conv2d_linear_5_buffer_var, sid_69_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_16(sid_69_let, weight_1x1_conv2d_6_buffer_var, sid_70_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_17(sid_70_let, weight_depth_wise_6_buffer_var, sid_71_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_18(sid_71_let, weight_1x1_conv2d_linear_6_buffer_var, sid_72_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_19(sid_72_let, weight_1x1_conv2d_7_buffer_var, sid_73_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_20(sid_73_let, weight_depth_wise_7_buffer_var, sid_74_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_21(sid_74_let, weight_1x1_conv2d_linear_7_buffer_var, sid_75_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_22(sid_75_let, weight_1x1_conv2d_8_buffer_var, sid_76_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_23(sid_76_let, weight_depth_wise_8_buffer_var, sid_77_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_24(sid_77_let, weight_1x1_conv2d_linear_8_buffer_var, sid_78_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_25(sid_78_let, weight_1x1_conv2d_9_buffer_var, sid_79_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_26(sid_79_let, weight_depth_wise_9_buffer_var, sid_80_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_27(sid_80_let, weight_1x1_conv2d_linear_9_buffer_var, sid_81_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_28(sid_81_let, weight_1x1_conv2d_10_buffer_var, sid_82_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_29(sid_82_let, weight_depth_wise_10_buffer_var, sid_83_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_30(sid_83_let, weight_1x1_conv2d_linear_10_buffer_var, sid_84_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_31(sid_84_let, weight_1x1_conv2d_11_buffer_var, sid_85_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_32(sid_85_let, weight_depth_wise_11_buffer_var, sid_86_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_33(sid_86_let, weight_1x1_conv2d_linear_11_buffer_var, sid_87_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_34(sid_87_let, weight_1x1_conv2d_12_buffer_var, sid_88_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_35(sid_88_let, weight_depth_wise_12_buffer_var, sid_89_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_36(sid_89_let, weight_1x1_conv2d_linear_12_buffer_var, sid_90_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_37(sid_90_let, weight_1x1_conv2d_13_buffer_var, sid_91_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_38(sid_91_let, weight_depth_wise_13_buffer_var, sid_92_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_39(sid_92_let, weight_1x1_conv2d_linear_13_buffer_var, sid_93_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_40(sid_93_let, weight_1x1_conv2d_14_buffer_var, sid_94_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_41(sid_94_let, weight_depth_wise_14_buffer_var, sid_95_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_42(sid_95_let, weight_1x1_conv2d_linear_14_buffer_var, sid_96_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_43(sid_96_let, weight_1x1_conv2d_15_buffer_var, sid_97_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_44(sid_97_let, weight_depth_wise_15_buffer_var, sid_98_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_45(sid_98_let, weight_1x1_conv2d_linear_15_buffer_var, sid_99_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_46(sid_99_let, weight_1x1_conv2d_16_buffer_var, sid_100_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_47(sid_100_let, weight_depth_wise_16_buffer_var, sid_101_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_48(sid_101_let, weight_1x1_conv2d_linear_16_buffer_var, sid_102_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_49(sid_102_let, weight_1x1_conv2d_17_buffer_var, sid_103_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_50(sid_103_let, weight_depth_wise_17_buffer_var, sid_104_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_51(sid_104_let, weight_1x1_conv2d_linear_17_buffer_var, sid_105_let, global_workspace_0_var) != 0 ) return -1;
  if (tvmgen_default_fused_nn_conv2d_52(sid_105_let, conv2d_2_buffer_var, output_buffer_var, global_workspace_0_var) != 0 ) return -1;
  return 0;
}

