
# Supplementary Materials for NeurIPS Submission 28707

This repository contains supplementary materials for the NeurIPS submission titled **World-aware Planning Narratives Enhance Large Vision-Language Model Planner**. It includes code for data generation, modified components of the `EmbodiedBench` framework, and the supplementary PDF document.

---

## 📁 Repository Structure

```
.
├── data_generation/                  # Code for generating training/evaluation data
│   ├── generate_implicit.py          # Script for implicit data generation
│   ├── generate_normal.py            # Script for standard data generation
│   └── update_stepwise_reasoning.py  # Logic for stepwise reasoning updates
│
├── embodiedbench_changed_part/       # Modified components of EmbodiedBench
│   ├── configs/                      # Configuration files
│   ├── envs/                         # Custom environment definitions
│   ├── evaluator/                    # Evaluation metrics and logic
│   ├── planner/                      # Task planning modules
│   └── main_alfred.py                # Modified entry point for ALFRED tasks
│
├── NeurIPS_supplementary_submission_28707.pdf  # Supplementary PDF document
├── Readme.md                         # This file
│
├── visual_enhanced_result.zip        # Pre-generated visual-enhanced results
└── ...                               # Other auxiliary files/dirs
```

---

## 🛠️ Setup & Usage

### Data Generation
1. Install dependencies:  
   ```bash
   pip install vllm  
   ```
2. Run generation scripts:  
   ```bash
   python data_generation/generate_implicit.py
   python data_generation/generate_normal.py
   ```
3. Update reasoning logic:  
   ```bash
   python data_generation/update_stepwise_reasoning.py
   ```

### EmbodiedBench Modifications
To apply our changes to the original [EmbodiedBench](https://github.com/EmbodiedBench/EmbodiedBench):  
1. Replace the corresponding directories/files in EmbodiedBench with those in `embodiedbench_changed_part/`.
2. Follow the original execution instructions and test your models.

### Visual Enhanced Results
Unzip `visual_enhanced_result.zip` to view pre-generated outputs.

---

## 📄 Supplementary PDF
See `NeurIPS_supplementary_submission_28707.pdf` for:  
- Limitation
- Implementation details  
- Additional samples and prompts

