from sacred import Experiment

ex = Experiment("Language Model can share image")


@ex.config
def config():
    seed = 42

    data_root = ""
    log_dir = ""
    model_name = ""
    file_version = ""

    datatype = "test"

    task_type = ""

    max_prompt_len = 256
    max_output_len = 128
    consecutive_turn = False

    sampled_test = True
    sampled_num = 0

    batch_size = 0

    # openai_setting
    api_key = ""
    organization = ""
    max_len = 1024
    temp = 0.9
    num_log_probs = 5
    echo = False
    n = 1
    stop = '\n'
    freq_penalty = 1.0
    pres_penalty = 0.6
    top_p = 0.95
    rounding_step = 0

    # prompt template
    template_type = ""

@ex.named_config
def task_intent_prediction():
    log_dir = './logs'

    template_type = "image-sharing-turn-prediction-v8"

    task_type = "task1"

    max_len = 1024
    temp = 0.0
    num_log_probs = 5
    echo = False
    n = 1
    stop = '\n'
    freq_penalty = 0.0
    pres_penalty = 0.0
    top_p = 1.0
    rounding_step = 0

@ex.named_config
def task_caption_generation():
    log_dir = './logs/task2_for_photochat'
    
    max_len = 1024
    temp = 0.9
    num_log_probs = 5
    echo = False
    n = 1
    stop = None
    freq_penalty = 0.0
    pres_penalty = 0.4
    top_p = 0.95
    rounding_step = 0

@ex.named_config
def task_grammar_correction():
    log_dir = './logs/grammar_correction_for_photochat'

    max_len = 1024
    temp = 0
    num_log_probs = 5
    echo = False
    n = 1
    stop = None
    freq_penalty = 0.0
    pres_penalty = 0.0
    top_p = 0.0
    rounding_step = 0
    
@ex.named_config
def photochat_setting():
    data_root = "./data/photochat"