#!/bin/bash

# Ada, Babbage, Curie and Davinci line up closely with 350M, 1.3B, 6.7B, and 175B respectively
LLM_MODEL_NAMES=("gpt-3.5-turbo") # "gpt-4")
#LLM_MODEL_NAMES=("text-ada-001" "text-babbage-001" "text-curie-001" "text-davinci-001" "text-davinci-002" "text-davinci-003") # "text-davinci-003") #"text-ada-001" "text-babbage-001" "text-curie-001" 

for MODEL_NAME in "${LLM_MODEL_NAMES[@]}"
do
    python3 parse.py \
        --model_name ${MODEL_NAME} \
        --report_save_dir ./reports \
        --template_type image-sharing-turn-prediction-v8 \
        --file_version v5 \
        --seed 42 \
        --rounding_step 3
done