import os
import re
import random
import numpy as np
import torch


OPENAI_MODEL_NAMES = [
    "ada",
    "babbage",
    "curie",
    "davinci",
    "text-ada-001",
    "text-babbage-001",
    "text-curie-001",
    "text-davinci-001",
    "text-davinci-002",
    "text-davinci-003"
]

OPENAI_CHAT_MODEL_NAMES = [
    "gpt-3.5-turbo",
    "gpt-4"
]

def fixed_seed(seed):
    os.environ["PYTHONHASHSEED"] = str(seed)
    os.environ['CUDA_LAUNCH_BLOCKING'] = "1"
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)

re_art = re.compile(r'\b(a|an|the)\b')
re_punc = re.compile(r'[!"#$%&()*+,-./:;<=>?@\[\]\\^`{|}~_\'\’]')
re_punc1 = re.compile(r'[!">\.,\'\’\\\/]')

def normalize_answer(s):
	"""
    Lower text and remove punctuation, articles and extra whitespace.
    """
	s = s.lower()

	s = s.replace("thats", "that's")
	s = s.replace("whatd", "what'd")

	s = s.replace("i liove thsi phto", "i love this photo")
	s = s.replace("definitly", "definitely")
	#s = s.replace("A gun????", "A gun???")
	#s = s.replace("mmm", "mm")
	s = re_punc1.sub(' ', s)
	#s = re_art.sub(' ', s)
	# TODO: this could almost certainly be faster with a regex \s+ -> ' '
	s = ' '.join(s.split())
	return s