# AsyCo

This repository is the official implementation of Generative Noisy-Label Learning by Implicit Dicriminative Approximation with Partial Label Prior. 

## Requirements

- To install requirements:
  ```setup
  pip install -r requirements.txt
  ```
- 1 * NVIDIA RTX 3090
## Datasets Preparation
[CIFAR10/100](https://www.cs.toronto.edu/~kriz/cifar.html), [CIFAR10/100N](https://github.com/UCSC-REAL/cifar-10-100n), [RedMini-ImageNet](https://google.github.io/controlled-noisy-web-labels/index.html), [Animal-10N](https://dm.kaist.ac.kr/datasets/animal-10n/), [Clothing1M](https://github.com/Cysu/noisy_label)
## Training

### Training on CIFAR
- Download [CIFAR10/100](https://www.cs.toronto.edu/~kriz/cifar.html).

- Train on CIFAR10

```
python Train_cifar.py --data_path <data_dir> --r <noise_rate> --warmup_epochs 10 --desc default --num_class 10 --noise_mode instance
```

- Train on CIFAR100
```
python Train_cifar.py --data_path <data_dir> --r <noise_rate> --warmup_epochs 15 --desc default --num_class 100 --noise_mode instance
```


where the arguments represent:
* `data_dir` - CIFAR dataset dir
* `r` - noise rates
* `warmup_epochs` - number of warmup epochs
* `desc` - prefix for log files
* `noise_mode` - noise types
* `num_class` - numer of classes
* `dataset` - CIFAR10/100

### Training on CIFAR10/100N
- [CIFAR10/100N](https://github.com/UCSC-REAL/cifar-10-100n) and place `CIFAR-10_human.pt` and `CIFAR-100_human.pt` under this repo.

- Train CIFAR10N 
```
python Train_cifarN.py --data_path <data_dir> --target <noise type> --warmup_epochs 10 --desc default --num_class 10 --noise_mode instance
```

- Train CIFAR100N
```
python Train_cifarN.py --data_path <data_dir> --target noisy_label --warmup_epochs 15 --desc default --num_class 100 --noise_mode instance
```

- please ignore the logging info about noise rates, they are set to default value of argparse and not reflect true noise types of CIFAR10/100N. They will be removed in future version.


### Training on Red Mini-ImageNet
- Download [Red Mini-ImageNet](https://google.github.io/controlled-noisy-web-labels/index.html).

- Train Red Mini-ImageNet
```
python Train_red.py --data_path /run/media/Data/red_blue/ --r <noise rate> --desc default --noise_mode instance --warmup_epochs 15
  
```

### Training on Animal-10N
- Download [Animal-10N](https://dm.kaist.ac.kr/datasets/animal-10n/) raw image version.

- Train Animal-10N:
```
python Train_animal10n.py --data_path <data_dir> 
```

### Training on Clothing1M
- Download [Clothing1M](https://github.com/Cysu/noisy_label).

- Train Clothing1M:
```
python Train_clothing1M.py --data_path <data_dir> 
```


