#!/usr/bin/env python
# coding: utf-8

# In[1]:


import pickle
import matplotlib.pyplot as plt

with open('./szoht/curves.pickle', 'rb') as file:
    szoht_curve = pickle.load(file)

with open('./vrzht/curves.pickle', 'rb') as file:
    vrszht_curve = pickle.load(file)

with open('./fullgrad/curves.pickle', 'rb') as file:
    fullgrad_curve = pickle.load(file)

with open('./sarah/curves.pickle', 'rb') as file:
    sarahcurve = pickle.load(file)

with open('./saga/curves.pickle', 'rb') as file:
    sagacurve = pickle.load(file)



plt.figure()
for curve, name in zip([fullgrad_curve, vrszht_curve, szoht_curve, sarahcurve, sagacurve], ['FGZOHT',  'VR-SZHT', 'SZOHT','SARAH-ZHT', 'SAGA-ZHT']):
    plt.plot(curve['nizo'], curve['hist'], linestyle='-', marker='^', markersize=5, label=f"{name}")
plt.legend()
plt.ylabel(r'$\mathcal{F}(\theta)$', fontweight='bold', fontsize=20)
plt.xlabel('# IZO', fontsize=20)
plt.show()


# In[2]:


plt.figure()
for curve, name in zip([fullgrad_curve, vrszht_curve, szoht_curve, sarahcurve, sagacurve], ['FGZOHT',  'VR-SZHT', 'SZOHT','SARAH-ZHT', 'SAGA-ZHT']):
    plt.plot(curve['nht'], curve['hist'], linestyle='-', marker='^', markersize=5, label=f"{name}")
plt.legend()
plt.ylabel(r'$\mathcal{F}(\theta)$', fontweight='bold', fontsize=20)
plt.xlabel('# NHT', fontsize=20)
plt.show()


# In[ ]:





# In[ ]:




