# Check if required command line arguments are provided
if [ $# -lt 3 ]; then
    echo "Usage: bash script.sh <q_value> <k_value> <dataset>"
    exit 1
fi




q=$1
k=$2
dataset=$3

eta=0.001
lam=0.5
mu=0.0001
pf=1
bs=1
uf=19
zomax=200000

gd=(0.0000001 0.000001 0.00001 0.0001 0.001 0.01 0.1 1)

shortpath="${dataset}_q_${q}_k_${k}"
path="./results/${shortpath}"

algorithms=("fgzoht" "szoht" "svrgzoht" "sarah-zht" "saga-zht" "q-saga-zht-10" "q-saga-zht-20")

mkdir "$path"; \
rm "$path/results_mean.csv" ; \
rm "$path/results_std.csv" ; \
rm "$path/it_count.csv" ; \
rm "$path/nizo.csv"; \
rm "$path/nht.csv"

for algorithm in "${algorithms[@]}"
do
    command="python main.py -d $dataset -a $algorithm --nruns 5 --iter 100000000000000000000000 --zomax $zomax --eta $eta --mu $mu --q $q --lam $lam --k $k --plot_freq $pf --batch_size $bs --update_freq $uf -t $path -g ${gd[*]}"
    eval "$command"
done
