#!/bin/bash

# List of classes
classes=('airplane' 'bird' 'ship' 'dog')

# Exit the script if any command returns a non-zero status
set -e

# Iterate over each class
for class in "${classes[@]}"; do
    echo "Processing class: $class"
    
    # Change to the corresponding directory
    cd "adversarial_attacks_$class"

    rm sarah/*; rm saga/*; rm szoht/*; rm fullgrad/*; rm vrzht/*

    # Execute the task using taskset
    taskset -c 1-64 bash ./run_all.sh

    # Move back to the original directory
    cd ..
done