#!/bin/bash

export WANDB_API_KEY="0054fda6ed25eace6e3c37c9042258f123cccf4c"

# Detect number of GPUs (requires nvidia-smi)
N_GPUS=$(nvidia-smi --list-gpus | wc -l)
echo "Detected $N_GPUS GPUs"

source /home/XXXX-3/miniforge3/bin/activate minir1
module load cuda/12.1

cd /home/XXXX-3/forecasting/cawn/

# Run the classifier with accelerate
# Arguments are now passed directly with their parameter names
# accelerate launch src/mcq_classifier.py "$@"

# Run accelerate with the detected number of GPUs
accelerate launch --config_file scripts/zero3_config.yaml --num_processes $N_GPUS src/mcq_classifier.py "$@"
conda deactivate