#!/bin/bash

# Example script for running Paleka evaluation
# Modify paths according to your setup

# Activate the environment
cd /home/XXXX-3/forecasting/
source forecast/bin/activate
module load cuda/12.1

cd /home/XXXX-3/forecasting/custom_eval_scripts

# Set your model directory and other parameters
MODEL_DIR="/fast/XXXX-3/models/Qwen3-1.7B"
DATA_DIR="/home/XXXX-3/forecasting/custom_eval_scripts/tuples_2028"
OUTPUT_DIR="/fast/XXXX-3/forecasting/evals/paleka"
MAX_TOKENS=16384
NUM_GENERATIONS=3

# Run the evaluation
python eval_paleka.py \
    --model_dir "$MODEL_DIR" \
    --data_dir "$DATA_DIR" \
    --base_save_dir "$OUTPUT_DIR" \
    --max_new_tokens "$MAX_TOKENS" \
    --num_generations "$NUM_GENERATIONS"

echo "Evaluation complete! Check $OUTPUT_DIR for results." 