import json

# Load the JSON data from the specified file
input_file_path = 'data/metaculus_resolved.json'
output_file_path = 'data/metaculus_resolved_filtered.json'

# Read the JSON data from the input file
with open(input_file_path, 'r') as input_file:
    data = json.load(input_file)

# Filter out items where the 'resolution' field is None
filtered_data = [item for item in data if item['resolution'] is not None]

# Write the filtered data to the output file
with open(output_file_path, 'w') as output_file:
    json.dump(filtered_data, output_file, indent=2)

print(f"{len(filtered_data)} questions saved to {output_file_path}")