# Forecasting Model Response Viewer

A lightweight web application for viewing and analyzing model responses from forecasting experiments with step-by-step reasoning visualization.

## Features

- **Clean, Modern Interface**: View forecasting model responses in a visually appealing format
- **Interactive Components**: Toggle detailed information, expand/collapse reasoning steps
- **Question Parsing**: Automatically extracts questions, options, and additional details from prompts
- **Reasoning Visualization**: See the model's step-by-step reasoning process with interactive toggles
- **Probability Visualization**: Visual representation of probability distributions for each step
- **Summary Statistics**: View overall performance metrics across all responses
- **Responsive Design**: Works on desktop, tablet, and mobile devices

## How to Use

1. **Setup:**
   No installation required! The viewer is a static web application that runs entirely in the browser.

2. **Launch the Viewer:**
   - Option 1: Use the included shell script
     ```bash
     cd viewer
     ./run.sh
     ```
     This starts a local web server on port 8000.
   
   - Option 2: Open directly in browser
     - Double-click the `index.html` file
     - Open with your browser's File → Open menu
     - Drag and drop the file into your browser

3. **Load Your JSON Data:**
   - Click the "Load JSON File" button
   - Select your JSON file containing model responses
   - The file should contain an array of response objects

4. **Interact with the Viewer:**
   - View summary statistics at the top
   - Browse through responses with pagination
   - Click "Show additional details" to view background information and resolution criteria
   - Click on reasoning steps to expand/collapse each step
   - See the final probabilities with visual representation
   - Color-coded indicators show correct/incorrect predictions

## Understanding the Display

The viewer organizes each model response into the following sections:

1. **Question and Options**
   - Shows the main question and answer options
   - Additional details (background, resolution criteria) are hidden behind a toggle

2. **Initial Response**
   - Shows the model's initial text before it begins reasoning

3. **Reasoning Steps**
   - Collapsible sections for each step in the model's reasoning process
   - Each step shows:
     - The model's thinking for that step
     - Updated probability distribution with visual bars

4. **Final Probabilities**
   - Visual representation of the model's final probability distribution
   - Highest probability option is highlighted

5. **Answer Comparison**
   - Shows the model's selected answer vs. the correct answer
   - Color-coded for easy identification of correct/incorrect predictions

## JSON Data Format

The viewer works with JSON files containing an array of response objects with the following structure:

```json
[
  {
    "model": "model-name",
    "prompt": "The original prompt text with question, options, background...",
    "response": "The model's response with <think>...</think> and <prior_n>...</prior_n> tags",
    "values": [0.05, 0.3, 0.65],
    "answer1": "C",
    "resolution": "C",
    "skipped": false
  }
]
```

Key fields:
- `model`: Name of the model
- `prompt`: Original prompt including the question and options
- `response`: Full model response including thinking and probability updates
- `values`: Final probability distribution for each answer option
- `answer1`: Model's final answer (typically a letter like "A", "B", "C")
- `resolution`: Correct answer
- `skipped`: Boolean indicating if the model skipped the question

## Browser Compatibility

The viewer works in all modern browsers:
- Chrome (recommended)
- Firefox
- Safari
- Edge

## License

This project is open source and free to use. 