#!/bin/bash

echo "Starting Forecasting Model Response Viewer..."

# Check if Python is installed
if command -v python3 &>/dev/null; then
    echo "Using Python 3 to start a local web server..."
    # Start a simple HTTP server using Python 3
    python3 -m http.server 8000
elif command -v python &>/dev/null; then
    # Check Python version
    PYTHON_VERSION=$(python --version 2>&1)
    if [[ $PYTHON_VERSION == *"Python 3"* ]]; then
        echo "Using Python 3 to start a local web server..."
        python -m http.server 8000
    else
        echo "Using Python 2 to start a local web server..."
        python -m SimpleHTTPServer 8000
    fi
else
    echo "Error: Python is not installed. Please install Python or use another web server."
    exit 1
fi 