#!/bin/bash

# VENV_PATH="/home/XXXX-3/miniforge3/envs/trainingtt/"

# source "$VENV_PATH/bin/activate"

if [ $# -eq 0 ]; then
    echo "Please provide a Python file name as argument"
    exit 1
fi

# Detect number of GPUs (requires nvidia-smi)
N_GPUS=$(nvidia-smi --list-gpus | wc -l)
echo "Detected $N_GPUS GPUs"

export WANDB_API_KEY="7133f16727b5ee93dc95d4cbf35ebaa37e2310a4"

source /home/XXXX-3/miniforge3/bin/activate minir1
module load cuda/12.1

cd /home/XXXX-3/forecasting/baselines/mcq_classifier
# accelerate launch mmlu_pro_4way.py
# accelerate launch mengye.py
# accelerate launch mmlu_try.py
# accelerate launch mmlu_pro_try.py
# accelerate launch manifold.py
# accelerate launch super_gqpa.py
# accelerate launch mmlu_multi_evals.py
# accelerate launch multi_evals.py
# accelerate launch super_gqpa_4way.py
# bash scripts/check_halawi_train.sh $1 $2

# accelerate launch "$1"
accelerate launch --config_file zero3_config.yaml --num_processes $N_GPUS "$1"
conda deactivate
