#!/usr/bin/env python3

import os
import sys

def remove_prefix_from_files(directory_path, prefix_to_remove):
    """
    Remove a specific prefix from all files in a directory.
    
    Args:
        directory_path: Path to the directory containing files
        prefix_to_remove: The prefix to remove from filenames
    """
    if not os.path.exists(directory_path):
        print(f"Directory does not exist: {directory_path}")
        return
    
    if not os.path.isdir(directory_path):
        print(f"Path is not a directory: {directory_path}")
        return
    
    files = os.listdir(directory_path)
    renamed_count = 0
    
    for filename in files:
        if filename.startswith(prefix_to_remove):
            old_path = os.path.join(directory_path, filename)
            new_filename = filename[len(prefix_to_remove):]
            new_path = os.path.join(directory_path, new_filename)
            
            # Check if target file already exists
            if os.path.exists(new_path):
                print(f"Warning: Target file already exists, skipping: {new_filename}")
                continue
            
            try:
                os.rename(old_path, new_path)
                print(f"Renamed: {filename} -> {new_filename}")
                renamed_count += 1
            except OSError as e:
                print(f"Error renaming {filename}: {e}")
    
    print(f"\nTotal files renamed: {renamed_count}")

if __name__ == "__main__":
    directory = "/fast/XXXX-3/forecasting/evals/paleka/Qwen3-4B"
    prefix = "Qwen3-4B_"
    
    print(f"Removing prefix '{prefix}' from files in: {directory}")
    remove_prefix_from_files(directory, prefix) 