<div align="center">
 👋 Hi, everyone! 
    verl is a RL training library initiated by <b>ByteDance Seed team</b> and maintained by the verl community.
    <br>
    <br>
</div>

<div align="center">

<a href="XXXX"><img src="XXXX" alt="Ask DeepWiki.com" style="height:20px;"></a>
[XXXX](XXXX)
[XXXX](XXXX)
<a href="XXXX"><img src="XXXX"></a>
<a href="XXXX"><img src="XXXX"></a>
[XXXX](XXXX)
<a href="XXXX"><img src="XXXX微信-green?logo=wechat&amp"></a>

</div>

XXXX

<h1 style="text-align: center;">verl: Volcano Engine Reinforcement Learning for LLMs</h1>

verl is a flexible, efficient and production-ready RL training library for large language models (LLMs).

verl is the open-source version of **[HybridFlow: A Flexible and Efficient RLHF Framework](XXXX)** paper.

verl is flexible and easy to use with:

- **Easy extension of diverse RL algorithms**: The hybrid-controller programming model enables flexible representation and efficient execution of complex post-training dataflows. Build RL dataflows such as GRPO, PPO in a few lines of code.

- **Seamless integration of existing LLM infra with modular APIs**: Decouples computation and data dependencies, enabling seamless integration with existing LLM frameworks, such as FSDP, Megatron-LM, vLLM, SGLang, etc

- **Flexible device mapping**: Supports various placement of models onto different sets of GPUs for efficient resource utilization and scalability across different cluster sizes.

- Ready integration with popular HuggingFace models

verl is fast with:

- **State-of-the-art throughput**: SOTA LLM training and inference engine integrations and SOTA RL throughput.

- **Efficient actor model resharding with 3D-HybridEngine**: Eliminates memory redundancy and significantly reduces communication overhead during transitions between training and generation phases.

</p>

## News
- [2025/07] The [ReTool](XXXX) recipe is fully open sourced. [Blog](XXXX)
- [2025/07] The first verl meetup will be held at ICML Vancouver on July 16th! Please [join us](XXXX) if you are at ICML! (onsite only)
- [2025/07] verl keynote at [AWS AI Hours Singapore](XXXX) on 7/8, verl & verl-agent project updates at [Agent for SWE meetup](XXXX) by LF AI & Data Singapore on 7/11.
- [2025/06] verl with Megatron backend enables large MoE models such as [DeepSeek-671b and Qwen3-236b](XXXX).
- [2025/06] verl team will provide latest project updates at [PyTorch Day China](XXXX) on June 7th. Meet our dev team in Beijing!
- [2025/04] [Seed-Thinking-v1.5](XXXX) tech report is released! Trained with verl, Seed-Thinking-v1.5 achieves 86.7 on AIME 2024, 55.0 on Codeforces and 77.3 on GPQA, demonstrating excellent reasoning abilities in STEM and coding. Beyond reasoning tasks, the method demonstrates notable generalization across diverse domains.
- [2025/03] [DAPO](XXXX) is the open-sourced SOTA RL algorithm that achieves 50 points on AIME 2024 based on the Qwen2.5-32B pre-trained model, surpassing the previous SOTA achieved by DeepSeek's GRPO (DeepSeek-R1-Zero-Qwen-32B). DAPO's training is fully powered by verl and the reproduction code is available in `recipe/dapo` now.
<details><summary> more... </summary>
<ul>
  <li> [2025/04] [VAPO](XXXX) (value-based augmented PPO) paper covers our latest RL method for reasoning models. Trained from Qwen-32B-base model, VAPO achieves 60.4 on AIME 2024, outperforming DAPO-32B.</li>
  <li>[2025/05] [PF-PPO](XXXX), accepted to ICML 2025, is now supported in verl! PF-PPO enhances policy learning efficiency and robustness by filtering potentially noisy reward signals and reusing high-quality experiences via a replay buffer.</li>
  <li>[2025/04] We will give a tutorial about latest post-training techniques and programming guide for verl at [ICLR 2025 Expo](XXXX=), [SCI-FM workshop](XXXX) and [LMSys afterparty](XXXX). Talk materials available [here](XXXX). </li>
  <li>[2025/03] verl v0.3.0.post1 is released! See [release note](XXXX) for details. It achieves [~1.4x speedup](XXXX) compared to prev versions.</li>
  <li>[2025/05] verl will be presented at [A2M Shanghai](XXXX) on 5/16 - 5/17.</li>
  <li>[2025/05] verl will be presented at [GOSIM x PyTorch Day 2025](XXXX). See you in Paris! </li>
  <li>[2025/03] We introduced the programming model of verl at the [vLLM Beijing Meetup](XXXX) and [verl intro and updates](XXXX) at the [SGLang-LMSYS Org Meetup](XXXX) in Sunnyvale mid-March.</li>
  <li>[2025/03] We will present verl(HybridFlow) at EuroSys 2025. See you in Rotterdam!</li>
  <li>[2025/02] verl v0.2.0.post2 is released!</li>
  <li>[2025/02] We presented verl in the <a href="XXXX">Bytedance/NVIDIA/Anyscale Ray Meetup</a>. See you in San Jose!</li>
  <li>[2025/01] [Doubao-1.5-pro](XXXX) is released with SOTA-level performance on LLM & VLM. The RL scaling preview model is trained using verl, reaching OpenAI O1-level performance on math benchmarks (70.0 pass@1 on AIME).</li>
  <li>[2024/12] verl is presented at Ray Forward 2024. Slides available <a href="XXXX">here</a></li>
  <li>[2024/12] The team presented <a href="XXXX">Post-training LLMs: From Algorithms to Infrastructure</a> at NeurIPS 2024. <a href="XXXX">Slides</a> and <a href="XXXX">video</a> available.</li>
  <li>[2024/10] verl is presented at Ray Summit. <a href="XXXX">Youtube video</a> available.</li>
  <li>[2024/08] HybridFlow (verl) is accepted to EuroSys 2025.</li>
</ul>   
</details>

## Key Features

- **FSDP**, **FSDP2** and **Megatron-LM** for training.
- **vLLM**, **SGLang** and **HF Transformers** for rollout generation.
- Compatible with Hugging Face Transformers and Modelscope Hub: [Qwen-3](XXXX), Qwen-2.5, Llama3.1, Gemma2, DeepSeek-LLM, etc
- Supervised fine-tuning.
- Reinforcement learning with [PPO](examples/ppo_trainer/), [GRPO](examples/grpo_trainer/), [ReMax](examples/remax_trainer/), [REINFORCE++](XXXX), [RLOO](examples/rloo_trainer/), [PRIME](recipe/prime/), [DAPO](recipe/dapo/), [DrGRPO](recipe/drgrpo), [KL_Cov & Clip_Cov](recipe/entropy) etc.
  - Support model-based reward and function-based reward (verifiable reward) for math, [coding](XXXX), etc
  - Support vision-language models (VLMs) and [multi-modal RL](examples/grpo_trainer/run_qwen2_5_vl-7b.sh) with Qwen2.5-vl, Kimi-VL
  - [Multi-turn with tool calling](XXXX)
- LLM alignment recipes such as [Self-play preference optimization (SPPO)](XXXX)
- Flash attention 2, [sequence packing](examples/ppo_trainer/run_qwen2-7b_seq_balance.sh), [sequence parallelism](examples/ppo_trainer/run_deepseek7b_llm_sp2.sh) support via DeepSpeed Ulysses, [LoRA](examples/sft/gsm8k/run_qwen_05_peft.sh), [Liger-kernel](examples/sft/gsm8k/run_qwen_05_sp2_liger.sh).
- Scales up to 671B models and hundreds of GPUs with [expert parallelism](XXXX)
- Multi-gpu [LoRA RL](XXXX) support to save memory.
- Experiment tracking with wandb, swanlab, mlflow and tensorboard.

## Upcoming Features and Changes

- Q3 Roadmap XXXX
- DeepSeek 671b optimizations with Megatron XXXX
- Multi-turn rollout and tools using optimizations XXXX
- [Agent integration](XXXX)
- Async and off-policy architecture XXXX
- List of breaking changes since v0.4 XXXX

## Getting Started

<a href="XXXX"><b>Documentation</b></a>

**Quickstart:**

- [Installation](XXXX)
- [Quickstart](XXXX)
- [Programming Guide](XXXX) & [Tech Talk](XXXX) (in Chinese)
- [PPO in verl](XXXX)
- [GRPO in verl](XXXX)

**Running a PPO example step-by-step:**


- [Prepare Data for Post-Training](XXXX)
- [Implement Reward Function for Dataset](XXXX)
- [PPO Example Architecture](XXXX)
- [Config Explanation](XXXX)

**Reproducible algorithm baselines:**

- [RL performance on coding, math](XXXX)

**For code explanation and advance usage (extension):**

- PPO Trainer and Workers
  - [PPO Ray Trainer](XXXX)
  - [PyTorch FSDP Backend](XXXX)
  - [Megatron-LM Backend](XXXX)

- Advanced Usage and Extension
  - [Add Models with the FSDP Backend](XXXX)
  - [Add Models with the Megatron-LM Backend](XXXX)
  - [Multi-turn Rollout Support](XXXX)
  - [Search Tool Integration](XXXX)
  - [Sandbox Fusion Integration](XXXX)
  - [Deployment using Separate GPU Resources](XXXX)
  - [Extend to Other RL(HF) algorithms](XXXX)
  - [Ray API design tutorial](XXXX)

**Blogs from the community**

- [When Reasoning Models Break Tokenization: The Hidden Complexity of Multiturn Training](XXXX)
- [verl deployment on AWS SageMaker](XXXX)
- [verl x SGLang Multi-turn Code Walkthrough](XXXX)
- [Optimizing SGLang Memory Usage in verl](XXXX)
- [SGLang, verl, OpenBMB and Tsinghua University: Pioneering End-to-End Multi-Turn RLHF](XXXX)
- [Reinforcement Learning from Human Feedback on AMD GPUs with verl and ROCm Integration](XXXX)
- [veMLP x verl ：玩转强化学习训练](XXXX)
- [使用 verl 进行 GRPO 分布式强化学习训练最佳实践](XXXX)
- [HybridFlow verl 原文浅析](XXXX)
- [最高提升 20 倍吞吐量！豆包大模型团队发布全新 RLHF 框架，现已开源！](XXXX)

## Performance Tuning Guide

The performance is essential for on-policy RL algorithm. We have written a detailed [performance tuning guide](XXXX) to help you optimize performance.

## Upgrade to vLLM >= v0.8.2

verl now supports vLLM>=0.8.2 when using FSDP as the training backend. Please refer to [this document](XXXX) for the installation guide and more information. Please avoid vllm 0.7.x, which contains bugs that may lead to OOMs and unexpected errors.

## Use Latest SGLang

SGLang is fully supported with verl, and SGLang RL Group is working extensively on building unique features, including multi-turn agentic RL, VLM RLHF, server-based RL, and partial rollout. Please refer to [this document](XXXX) for the installation guide and more information.

## Upgrade to FSDP2

verl is fully embracing FSDP2! FSDP2 is recommended by torch distributed team, providing better throughput and memory usage, and is composible with other features (e.g. torch.compile). To enable FSDP2, simply use verl main and set the following options:
```
actor_rollout_ref.ref.strategy=fsdp2
actor_rollout_ref.actor.strategy=fsdp2
critic.strategy=fsdp2 
reward_model.strategy=fsdp2 
```
Furthermore, FSDP2 cpu offloading is compatible with gradient accumulation. You can turn it on to save memory with `actor_rollout_ref.actor.fsdp_config.offload_policy=True`. For more details, see XXXX

## AMD Support (ROCm Kernel)

verl now supports FSDP as the training engine (Megatron support coming soon) and both integrates with vLLM and SGLang as inference engines. Please refer to [this document](XXXX) for the installation guide and more information, and [this document](XXXX) for the vLLM performance tuning for ROCm.


## Citation and acknowledgement

If you find the project helpful, please cite:

- [HybridFlow: A Flexible and Efficient RLHF Framework](XXXX)
- [A Framework for Training Large Language Models for Code Generation via Proximal Policy Optimization](XXXX)

```bibtex
@article{sheng2024hybridflow,
  title   = {HybridFlow: A Flexible and Efficient RLHF Framework},
  author  = {Guangming Sheng and Chi Zhang and Zilingfeng Ye and Xibin Wu and Wang Zhang and Ru Zhang and Yanghua Peng and Haibin Lin and Chuan Wu},
  year    = {2024},
  journal = {arXiv preprint arXiv: 2409.19256}
}
```

verl is inspired by the design of Nemo-Aligner, Deepspeed-chat and OpenRLHF. The project is adopted and contributed by Bytedance, Anyscale, LMSys.org, [Alibaba Qwen team](XXXX), Shanghai AI Lab, Tsinghua University, UC Berkeley, UCLA, UIUC, University of Hong Kong, ke.com, [All Hands AI](XXXX), [ModelBest](XXXX), JD AI Lab, Microsoft Research, [StepFun](XXXX), Amazon, LinkedIn, Meituan, [Camel-AI](XXXX), [OpenManus](XXXX), Xiaomi, NVIDIA research, [Baichuan](XXXX), [RedNote](XXXX), [SwissAI](XXXX), [Moonshot AI (Kimi)](XXXX), Baidu, Snowflake, Skywork.ai, JetBrains, [IceSword Lab](XXXX), and many more.

## Awesome work using verl

- [TinyZero](XXXX): a reproduction of **DeepSeek R1 Zero** recipe for reasoning tasks XXXX
- [SkyThought](XXXX): RL training for Sky-T1-7B by NovaSky AI team. XXXX
- [simpleRL-reason](XXXX): SimpleRL-Zoo: Investigating and Taming Zero Reinforcement Learning for Open Base Models in the Wild XXXX
- [Easy-R1](XXXX): **Multi-modal** RL training framework XXXX
- [OpenManus-RL](XXXX): LLM Agents RL tunning framework for multiple agent environments. XXXX
- [rllm](XXXX): async RL training with [verl-pipeline](XXXX) XXXX
- [RAGEN](XXXX): a general-purpose reasoning **agent** training framework XXXX
- [Search-R1](XXXX): RL with reasoning and **searching (tool-call)** interleaved LLMs XXXX
- [ReSearch](XXXX): Learning to **Re**ason with **Search** for LLMs via Reinforcement Learning XXXX
- [Skywork-OR1](XXXX): Skywork open reaonser series XXXX
- [ToRL](XXXX): Scaling tool-integrated RL XXXX
- [Absolute Zero Reasoner](XXXX): [A no human curated data self-play framework for reasoning](XXXX) XXXX
- [verl-agent](XXXX): A scalable training framework for **long-horizon LLM/VLM agents**, along with a new algorithm **GiGPO** XXXX
- [RL-Factory](XXXX): An easy and efficient RL post-training framework for Agentic Learning XXXX
- [ReTool](XXXX): ReTool: reinforcement learning for strategic tool use in LLMs. Code release is in progress...
- [verl-tool](XXXX): An unified and easy-to-extend tool-agent training framework based on verlXXXX
- [PRIME](XXXX): Process reinforcement through implicit rewards XXXX
- [MemAgent](XXXX): MemAgent: Reshaping Long-Context LLM with Multi-Conv RL based Memory Agent XXXX
- [POLARIS](XXXX): A Post-training recipe for scaling RL on Advanced Reasoning models XXXX
- [GUI-R1](XXXX): **GUI-R1**: A Generalist R1-style Vision-Language Action Model For **GUI Agents** XXXX
- [DeepRetrieval](XXXX): RL Training of **Search Agent** with **Search/Retrieval Outcome** XXXX
- [Code-R1](XXXX): Reproducing R1 for **Code** with Reliable Rewards XXXX
- [DeepResearcher](XXXX): Scaling deep research via reinforcement learning in real-world environments XXXX
- [VAGEN](XXXX): Training VLM agents with multi-turn reinforcement learning XXXX
- [RM-R1](XXXX): RL training of reasoning reward models XXXX
- [LUFFY](XXXX): Learning to Reason under Off-Policy GuidanceXXXX
- [DeepMath](XXXX): DeepMath-103K data and series models for math reasoningXXXX
- [Entropy Mechanism of RL](XXXX): The Entropy Mechanism of Reinforcement Learning for Large Language Model ReasoningXXXX
- [LLaSA-TTS-GRPO](XXXX): TTS fine-tuning with GRPO optimization based on LLASA models XXXX
- [PF-PPO](XXXX): Policy Filtration for PPO based on the reliability of reward signals for more efficient and robust RLHF.
- [RACRO](XXXX): Build multi-modal reasoning models via decoupling it into query-conditioned captioning and text-only reasoning XXXX
- [Agent Lightning](XXXX): A flexible and extensible framework that enables seamless agent optimization for any existing agent framework. XXXX

and many more awesome work listed in [recipe](recipe/README.md).

## Contribution Guide

See [contributions guide](CONTRIBUTING.md)

## About [ByteDance Seed Team](XXXX)

Founded in 2023, ByteDance Seed Team is dedicated to crafting the industry's most advanced AI foundation models. The team aspires to become a world-class research team and make significant contributions to the advancement of science and society. You can get to know Bytedance Seed better through the following channels👇
<div>
  <a href="XXXX">
    <img src="XXXX"></a>
  <a href="XXXX">
    <img src="XXXX"></a>
 <a href="XXXX">
    <img src="XXXX"></a>
  <a href="XXXX">
    <img src="XXXX"></a>

</div>
---

We are HIRING! Send us an [email](mailto:haibin.lin@bytedance.com) if you are interested in internship/FTE opportunities in RL for agents.
