## Selective Classification Suite

This codebase implements a selective classification suite.

### Support overview

The following algorithms are currently supported:
- Softmax Response (SR)
- SelectiveNet (SN)
- Deep Ensembles (DE)
- Monte Carlo Dropout (MCDO)
- Deep Gamblers (DG)
- Self-Adaptive Training (SAT)
- Selective Classifciation Training Dynamics (NNTD)

The following datasets are currently supported:
- MNIST
- FashionMNIST
- CIFAR-10
- CIFAR-100
- GTSRB
- SVHN
- Food101
- StanfordCars

### Setup

As usual, you should get started setting up an environment using conda and activating it. After making sure that pip is installed and cd'ing into this codebase, you can install this project's dependencies. The commands are as follows:

```bash
$ conda create -p /path/to/enviroment
$ conda activate /path/to/enviroment
$ cd sc
$ pip install -r requirements.txt
```

### Usage

For general usage, run

```bash
$ python main.py --help
```

It will print all available commands and parameteres.

**Example**: If you want to train a model on CIFAR-10 for 200 epochs with seed 42 on GPU with ID 0 and evaluate the selective classification performance using softmax response, then run the following command.

```bash
$ python main.py --sc-method sr --epochs 200 --dataset cifar10 --gpu-id 0 --seed 42
```