import torch
from torch.nn import functional as F


def deep_gambler_loss(outputs, targets, reward):
    outputs = F.softmax(outputs, dim=1)
    outputs, reservation = outputs[:, :-1], outputs[:, -1]
    gain = torch.gather(outputs, dim=1, index=targets.unsqueeze(1)).squeeze()
    doubling_rate = (gain.add(reservation.div(reward))).log()
    loss = -doubling_rate.mean()
    return loss
